/*========================================================================
    colors.h : Color definitions for CMVision2 and the Simple Image class
  ------------------------------------------------------------------------
    Copyright (C) 1999-2002  James R. Bruce
    School of Computer Science, Carnegie Mellon University
  ------------------------------------------------------------------------
    This software is distributed under the GNU General Public License,
    version 2.  If you do not have a copy of this licence, visit
    www.gnu.org, or write: Free Software Foundation, 59 Temple Place,
    Suite 330 Boston, MA 02111-1307 USA.  This program is distributed
    in the hope that it will be useful, but WITHOUT ANY WARRANTY,
    including MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
		========================================================================*/

#ifndef __COLORS_H__
#define __COLORS_H__

#define RGB_COLOR_NAMES

//==== Color Classes =================================================//

typedef unsigned char uchar;

#ifndef YUV_STRUCT
#define YUV_STRUCT
struct yuv{
  uchar y,u,v;
};

/* Depricated
struct yuv_int{
  int y,u,v;
};
*/
#endif

#ifndef YUVI_STRUCT
#define YUVI_STRUCT
struct yuvi{
  int y,u,v;
};
#endif

#ifndef YUVF_STRUCT
#define YUVF_STRUCT
struct yuvf{
  float y,u,v;
};
#endif

#ifndef YUYV_STRUCT
#define YUYV_STRUCT
struct yuyv{
  uchar y1,u,y2,v;
};
#endif

struct uyvy{
#ifndef UYVY_STRUCT
#define UYVY_STRUCT
  uchar u,y1,v,y2;
};
#endif

#ifndef RGB_STRUCT
#define RGB_STRUCT
struct rgb{
  uchar red,green,blue;

  rgb() : red(0), green(0), blue(0) {};

  rgb(int r, int g, int b)
    : red((uchar)r), green((uchar)g), blue((uchar)b)
  { };
			 

  bool operator ==(const rgb &x) const {
    return (red  ==x.red   &&
            green==x.green &&
            blue ==x.blue);
  }

  bool operator !=(const rgb &x) const {
    return !operator==(x);
  }
};
#endif

#ifndef RGBA_STRUCT
#define RGBA_STRUCT
struct rgba{
  uchar r,g,b,a;
};
#endif

#ifndef ARGB_STRUCT
#define ARGB_STRUCT
struct argb{
  uchar a,r,g,b;
};
#endif

#ifndef RGBF_STRUCT
#define RGBF_STRUCT
struct rgbf{
  float red,green,blue;

  rgbf()
		: red(0),green(0),blue(0) {}
  rgbf(float nred,float ngreen,float nblue)
		: red(nred),green(ngreen),blue(nblue) {}

};
#endif

#ifndef RGBAF_STRUCT
#define RGBAF_STRUCT
struct rgbaf{
  float r,g,b,a;
};
#endif

#ifndef ARGBF_STRUCT
#define ARGBF_STRUCT
struct argbf{
  float a,r,g,b;
};
#endif


//==== Color Names ===================================================//

#ifdef RGB_COLOR_NAMES
namespace Rgb{
/*   const rgb Black   = {  0,  0,  0}; */
/*   const rgb Blue    = {  0,128,255}; */
/*   const rgb Green   = {  0,128,  0}; */
/*   const rgb Orange  = {255,128,  0}; */
/*   const rgb Bgreen  = {  0,255,  0}; */
/*   const rgb Purple  = {128,  0,255}; */
/*   const rgb Red     = {255,  0,  0}; */
/*   const rgb Pink    = {255,128,224}; */
/*   const rgb Yellow  = {255,255,  0}; */
/*   const rgb Gray    = {200,200,200}; */
/*   const rgb Skin    = {150,100,  0}; */

/*   const rgb Black(0,  0,  0); */
/*   const rgb Blue(0,128,255); */
/*   const rgb Green(  0,128,  0); */
/*   const rgb Orange(255,128,  0); */
/*   const rgb Bgreen(0,255,  0); */
/*   const rgb Purple(128,  0,255); */
/*   const rgb Red(255,  0,  0); */
/*   const rgb Pink(255,128,224); */
/*   const rgb Yellow(255,255,  0); */
/*   const rgb Gray(200,200,200); */
/*   const rgb Skin(150,100,  0); */
}
#endif

#endif
