#ifndef INCLUDED_get_time_h
#define INCLUDED_get_time_h

#ifdef PLATFORM_APERIOS

//!a simple way to get the current time since boot in milliseconds (see TimeET for better accuracy)
unsigned int get_time();

#else //PLATFORM_LOCAL

//! If we're running locally, these will let users in "project" space control time for simulation
namespace project_get_time {
	//! This will default to -1, which signals get_time() to use get_time_callback.  Any other value will cause that value to be used instead.
	extern unsigned int simulation_time;
	//! This by default will return the time in milliseconds since the first call was made.  Note this is a function pointer, so you can reassign it to your own implementation!
	/*! For instance, the simulator can assign a function which forwards
	 *  the call to SharedGlobals::get_time(), so that all processes get
	 *  consistent time values under control of the simulator */
	extern unsigned int (*get_time_callback)();
}

//! This will call and return project_get_time::get_time_callback if project_get_time::simulation_time is -1.  Otherwise simulation_time is returned.
/*! Default values are set such that the system clock will be used,
 *  and values will range from 0 (first call) onward.   However, by
 *  reassigning project_get_time::get_time_callback to your own
 *  function, you can control the flow of time however you wish. */
inline unsigned int get_time() {
	if(project_get_time::simulation_time==-1U)
		return (*project_get_time::get_time_callback)();
	else
		return project_get_time::simulation_time;
}

#endif


/*! @file
 * @brief prototype for get_time(), a simple way to get the current time since boot in milliseconds
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_4 $
 * $Revision: 1.4 $
 * $State: Exp $
 * $Date: 2005/06/14 22:11:46 $
 */

#endif
