#include "OldHeadPointerMC.h"
#include "Shared/debuget.h"
#include "Shared/WorldState.h"
#include "MotionManager.h"
#include <math.h>
#include "Shared/Config.h"

OldHeadPointerMC::OldHeadPointerMC() :
  MotionCommand(), dirty(true), active(true), targetReached(false) {
  setWeight(1);
  defaultMaxSpeed();
  for(unsigned int i=0; i<NumHeadJoints; i++) {
    headModes[i]=BodyRelative;
    headTargets[i]=0;
    headCmds[i].value=state->outputs[HeadOffset+i];
  }
}

void OldHeadPointerMC::setJoints(double tilt, double pan, double roll) {
	setJointValue(TiltOffset,tilt);
	setJointValue(PanOffset,pan);
	setJointValue(RollOffset,roll);
}

void OldHeadPointerMC::setWeight(double w) {
  for(unsigned int x=0; x<NumHeadJoints; x++)
    headCmds[x].weight=w;
  dirty=true; targetReached=false;
}

void OldHeadPointerMC::defaultMaxSpeed() {
  maxSpeed[TiltOffset]=config->motion.max_head_tilt_speed*FrameTime/1000;
  maxSpeed[PanOffset]=config->motion.max_head_pan_speed*FrameTime/1000;
  maxSpeed[RollOffset]=config->motion.max_head_roll_speed*FrameTime/1000;
}

void OldHeadPointerMC::setMode(CoordFrame_t m, bool conv) {
  for(unsigned int x=0; x<NumHeadJoints; x++)
    setJointMode((RobotInfo::TPROffset_t)x,m,conv);
}

void OldHeadPointerMC::setJointMode(RobotInfo::TPROffset_t i, CoordFrame_t m, bool conv) {
  if(conv)
    headTargets[i]=OldHeadPointerMC::convert(i,headTargets[i],headModes[i],m);
  headModes[i]=m;
  dirty=true; targetReached=false;
}

int OldHeadPointerMC::updateOutputs() {
  int tmp=isDirty();
  if(tmp) {
    dirty=false;
    for(unsigned int i=0; i<NumHeadJoints; i++) {
      float value;
      if(headModes[i]!=BodyRelative) {
	value=convToBodyRelative((RobotInfo::TPROffset_t)i,headTargets[i],headModes[i]);
	dirty=true;
      } else
	value=headTargets[i];
      if(maxSpeed[i]<=0)
	headCmds[i].value=value;
      if(value==headCmds[i].value) {
	motman->setOutput(this,i+HeadOffset,headCmds[i]);
      } else { // we may be trying to exceeded maxSpeed
	unsigned int f=0;
	while(value>headCmds[i].value+maxSpeed[i] && f<NumFrames) {
	  headCmds[i].value+=maxSpeed[i];
	  motman->setOutput(this,i+HeadOffset,headCmds[i],f);
	  f++;
	}
	while(value<headCmds[i].value-maxSpeed[i] && f<NumFrames) {
	  headCmds[i].value-=maxSpeed[i];
	  motman->setOutput(this,i+HeadOffset,headCmds[i],f);
	  f++;
	}
	if(f<NumFrames) { //we reached target value, fill in rest of frames
	  headCmds[i].value=value;
	  for(;f<NumFrames;f++)
	    motman->setOutput(this,i+HeadOffset,headCmds[i],f);
	} else // we didn't reach target value, still dirty
	  dirty=true;
      }
    }
    float dist=0;
    for(unsigned int i=0; i<NumHeadJoints; i++) {
      float diff=(state->outputs[HeadOffset+i]-headTargets[i]);
      dist+=diff*diff;
    }
    if(dist<0.05*0.05 && !targetReached) {
      postEvent(EventBase(EventBase::motmanEGID,getID(),EventBase::statusETID));
      targetReached=true;
    }
  }
  return tmp;
}

const OutputCmd& OldHeadPointerMC::getOutputCmd(unsigned int i) {
  i-=HeadOffset;
  if(i<NumHeadJoints && getActive())
    return headCmds[i];
  else
    return OutputCmd::unused;
}

/*! @todo this is perhaps a bit amateurish - could be more accurate */
double OldHeadPointerMC::convToBodyRelative(TPROffset_t i, double v, CoordFrame_t mode) const {
  switch(mode) {
  default:
    ASSERT(false,"Passed bad mode "<<mode);
  case BodyRelative:
    return v;
  case GravityRelative: {
    double bacc=state->sensors[BAccelOffset];
    double lacc=state->sensors[LAccelOffset];
    double dacc=state->sensors[DAccelOffset];
    switch(i) {
    case TiltOffset:
      return v+atan2(bacc,sqrt(dacc*dacc+lacc*lacc));
    case PanOffset:
      return v;
    case RollOffset: //==NodOffset
      if(state->robotDesign&WorldState::ERS7Mask) {
	float pans=sin(state->outputs[HeadOffset+PanOffset]);
	float panc=cos(state->outputs[HeadOffset+PanOffset]);
	float ans=v;
	ans+=atan2(bacc*panc-lacc*pans,sqrt(dacc*dacc+lacc*lacc*panc*panc+bacc*bacc*pans*pans));
	ans-=panc*state->outputs[HeadOffset+TiltOffset];
	return ans;
      } else
	return v+atan2(-lacc,sqrt(dacc*dacc+bacc*bacc));
    default:
      ASSERT(false,"Passed bad offset "<<i<<" (use RobotInfo::TPROffset_t!)");
      return v;
    }
  }
  }
}

/*! @todo this is perhaps a bit amateurish - could be more accurate */
double OldHeadPointerMC::convFromBodyRelative(TPROffset_t i, double v, CoordFrame_t mode) const {
  switch(mode) {
  default:
    ASSERT(false,"Passed bad mode "<<mode);
  case BodyRelative:
    return v;
  case GravityRelative: {
    double bacc=state->sensors[BAccelOffset];
    double lacc=state->sensors[LAccelOffset];
    double dacc=state->sensors[DAccelOffset];
    switch(i) {
    case TiltOffset:
      return v-atan2(bacc,sqrt(dacc*dacc+lacc*lacc));
    case PanOffset:
      return v;
    case RollOffset: //==NodOffset
      if(state->robotDesign&WorldState::ERS7Mask) {
	float pans=sin(state->outputs[HeadOffset+PanOffset]);
	float panc=cos(state->outputs[HeadOffset+PanOffset]);
	float ans=v;
	ans-=atan2(bacc*panc-lacc*pans,sqrt(dacc*dacc+lacc*lacc*panc*panc+bacc*bacc*pans*pans));
	ans+=panc*state->outputs[HeadOffset+TiltOffset];
	return ans;
      } else
	return v-atan2(-lacc,sqrt(dacc*dacc+bacc*bacc));
    default:
      ASSERT(false,"Passed bad offset "<<i<<" (use RobotInfo::TPROffset_t!)");
      return v;
    }
  }
  }
}


/*! @file
 * @brief Implements OldHeadPointerMC, a class for various ways to control where the head is looking
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_4 $
 * $Revision: 1.1 $
 * $State: Exp $
 * $Date: 2004/10/14 20:23:50 $
 */


