//-*-c++-*-
#ifndef INCLUDED_Thread_h_
#define INCLUDED_Thread_h_

#ifdef PLATFORM_APERIOS
#  warning Thread class is not Aperios compatable
#else

#include <stddef.h>
#include <map>

namespace ThreadNS {
	class Lock {
	public:
		Lock();
		explicit Lock(const Lock& l, bool autolock=true) : my_id(l.my_id) { if(autolock) lock(); }
		//explicit Lock(int ident, bool autolock=true);
		~Lock();
		void lock();
		bool trylock();
		void unlock();
		int getID() const { return my_id; }
	protected:
		static std::map<int,struct LockStorage*> ids;
		static bool issetup;
		static void setup();
		int my_id;
	};	
}	

//! description of Thread
class Thread {
public:
	typedef ThreadNS::Lock Lock;
	Thread();
	virtual ~Thread()=0;
	
	virtual void start();
	virtual void * run();
	virtual unsigned int runloop() { return -1U; }
	virtual void stop();
	virtual void kill();
	virtual void murder();
	virtual void * join();
	virtual bool isRunning() const { return running; }
	
protected:
	virtual void testCancel();
	static void * launch(void * msg);
	static void handle_signal(int sig);
	static void handle_exit(void * th);
	
	struct Threadstorage_t * pt;
	bool running;
	void * returnValue;

private:
	Thread(const Thread& r); //!< don't call
	Thread& operator=(const Thread& r); //!< don't call
};

#endif //Aperios check

#endif

/*! @file
* @brief Describes the Thread class and its AutoThread templated subclass
* @author ejt (Creator)
*
* $Author: ejt $
* $Name: tekkotsu-2_4 $
* $Revision: 1.4 $
* $State: Exp $
* $Date: 2005/08/01 23:17:59 $
*/

