//-*-c++-*-
#ifndef INCLUDED_MessageReceiver_h_
#define INCLUDED_MessageReceiver_h_

#ifdef PLATFORM_APERIOS
#  warning MessageReceiver is not Aperios compatable
#else

#include "MessageQueue.h"
#include "Thread.h"

//! description of MessageReceiver
class MessageReceiver : public Thread {
public:
	explicit MessageReceiver(MessageQueueBase& mq, bool (*callback) (RCRegion*)=NULL, bool startThread=true);
	~MessageReceiver();
	
	RCRegion * peekNextMessage();
	RCRegion * getNextMessage();
	void markRead();
	void waitNextMessage();
	unsigned int runloop();
	void finish();
	
	void setCallback(bool (*callback) (RCRegion*)) { process=callback; }
	
protected:
	typedef MessageQueueBase::index_t index_t;
	MessageQueueBase& queue;
	unsigned int nextMessage;
	unsigned int lastProcessedMessage;
	bool (*process) (RCRegion*);
	unsigned int sleeptime;
	index_t curit;
	
private:
	MessageReceiver(const MessageReceiver& r); //!< don't call
	MessageReceiver& operator=(const MessageReceiver& r); //!< don't call
};

/*! @file
 * @brief 
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_4 $
 * $Revision: 1.5 $
 * $State: Exp $
 * $Date: 2005/07/28 18:22:16 $
 */

#endif //Aperios check

#endif //INCLUDED

