//-*-c++-*-
#ifndef INCLUDED_LockScope_h_
#define INCLUDED_LockScope_h_

#include "MutexLock.h"
#include "ProcessID.h"

//! Locks a MutexLock until the LockScope goes out of scope
/*! This can help prevent forgetting to do it if you function has multiple return points */
template<unsigned int num_doors>
class LockScope {
public:
	//!constructor, locks @a lock with the current process's id (ProcessID::getID())
	LockScope(MutexLock<num_doors>& lock) : l(lock) {l.lock(ProcessID::getID());}
	//!constructor, locks @a lock with @a id
	LockScope(MutexLock<num_doors>& lock, int id) : l(lock) {l.lock(id);}
	//!destructor, releases lock received in constructor
	~LockScope() { l.unlock(); }
protected:
	MutexLock<num_doors>& l; //!< the lock
};

/*! @file
 * @brief Defines LockScope, which locks a MutexLock until the LockScope goes out of scope
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_4 $
 * $Revision: 1.2 $
 * $State: Exp $
 * $Date: 2005/06/01 05:47:46 $
 */

#endif
