#include "VisionObjectEvent.h"
#include <sstream>
#include <libxml/tree.h>

// Changed 'getDescription' to show BB and area info in EventLogger. Change functions to add new parameters (BB and area) to buffer

std::string
VisionObjectEvent::getDescription(bool showTypeSpecific/*=true*/, unsigned int verbosity/*=0*/) const {
	if(!showTypeSpecific)
		return EventBase::getDescription(showTypeSpecific,verbosity);
	std::ostringstream logdata;
	logdata << EventBase::getDescription(showTypeSpecific,verbosity) << '\t' << _x1 <<  '\t' <<_x2 <<'\t' <<_y1 <<'\t' <<_y2<<'\t'<<_frame ;
	return logdata.str();
}

unsigned int
VisionObjectEvent::getBinSize() const {
	unsigned int used=EventBase::getBinSize();
	if(saveFormat==XML)
		return used; //if using XML, the XMLLoadSave::getBinSize (called by EventBase::getBinSize) is all we need
	//otherwise need to add our own fields
	used+=creatorSize("EventBase::VisionObjectEvent");
	used+=sizeof(_x1);
	used+=sizeof(_x2);
	used+=sizeof(_y1);
	used+=sizeof(_y2);
	return used;
}

unsigned int
VisionObjectEvent::LoadBinaryBuffer(const char buf[], unsigned int len) {
	unsigned int origlen=len;
	unsigned int used;
	if(0==(used=EventBase::LoadBinaryBuffer(buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=checkCreator("EventBase::VisionObjectEvent",buf,len,true))) return 0;
	len-=used; buf+=used;
	if(0==(used=decode(_x1,buf,len))) return 0;
	len-=used; buf+=used;	
	if(0==(used=decode(_x2,buf,len))) return 0;
	len-=used; buf+=used;	
	if(0==(used=decode(_y1,buf,len))) return 0;
	len-=used; buf+=used;	
	if(0==(used=decode(_y2,buf,len))) return 0;
	len-=used; buf+=used;	
	return origlen-len;	
}

unsigned int
VisionObjectEvent::SaveBinaryBuffer(char buf[], unsigned int len) const {
	unsigned int origlen=len;
	unsigned int used;
	if(0==(used=EventBase::SaveBinaryBuffer(buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=saveCreator("EventBase::VisionObjectEvent",buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=encode(_x1,buf,len))) return 0;
	len-=used; buf+=used;	
	if(0==(used=encode(_x2,buf,len))) return 0;
	len-=used; buf+=used;	
	if(0==(used=encode(_y1,buf,len))) return 0;
	len-=used; buf+=used;	
	if(0==(used=encode(_y2,buf,len))) return 0;
	len-=used; buf+=used;	
	return origlen-len;
}

void VisionObjectEvent::LoadXML(xmlNode* node) {
	if(node==NULL)
		return;
	
	EventBase::LoadXML(node);

	for(xmlNode* cur = skipToElement(node->children); cur!=NULL; cur = skipToElement(cur->next)) {
		if(xmlStrcmp(cur->name, (const xmlChar *)"param"))
			continue;

		xmlChar * name = xmlGetProp(cur,(const xmlChar*)"name");
		if(name==NULL)
			throw bad_format(cur,"property missing name");

		xmlChar * val = xmlGetProp(cur,(const xmlChar*)"value");
		if(val==NULL)
			throw bad_format(cur,"property missing value");

		if(xmlStrcmp(name, (const xmlChar *)"x1")==0)
			_x1=atof((const char*)val);
		else if(xmlStrcmp(name, (const xmlChar *)"x2")==0)
			_x2=atof((const char*)val);
		else if(xmlStrcmp(name, (const xmlChar *)"y1")==0)
			_y1=atof((const char*)val);
		else if(xmlStrcmp(name, (const xmlChar *)"y2")==0)
			_y2=atof((const char*)val);
		else if(xmlStrcmp(name, (const xmlChar *)"clipLeft")==0)
			_clipLeft=atoi((const char*)val);
		else if(xmlStrcmp(name, (const xmlChar *)"clipRight")==0)
			_clipRight=atoi((const char*)val);
		else if(xmlStrcmp(name, (const xmlChar *)"clipTop")==0)
			_clipTop=atoi((const char*)val);
		else if(xmlStrcmp(name, (const xmlChar *)"clipBottom")==0)
			_clipBottom=atoi((const char*)val);
		
		xmlFree(val);
		xmlFree(name);
	}
}

//! a little local macro to make saving fields easier
#define SAVE_PARAM(strname,varname,format) {\
xmlNode* cur=xmlNewChild(node,NULL,(const xmlChar*)"param",NULL); \
if(cur==NULL) \
throw bad_format(node,"Error: VisionObjectEvent xml error on saving param"); \
xmlSetProp(cur,(const xmlChar*)"name",(const xmlChar*)strname); \
char valbuf[20]; \
snprintf(valbuf,20,format,varname); \
xmlSetProp(cur,(const xmlChar*)"value",(const xmlChar*)valbuf); }

void VisionObjectEvent::SaveXML(xmlNode * node) const {
	if(node==NULL)
		return;
	EventBase::SaveXML(node);
	
	//clear old params first
	for(xmlNode* cur = skipToElement(node->children); cur!=NULL; ) {
		if(xmlStrcmp(cur->name, (const xmlChar *)"param")==0) {
			xmlUnlinkNode(cur);
			xmlFreeNode(cur);
			cur = skipToElement(node->children); //restart the search (boo)
		} else
			cur = skipToElement(cur->next);
	}
	
	SAVE_PARAM("x1",_x1,"%g");
	SAVE_PARAM("y1",_y1,"%g");
	SAVE_PARAM("x2",_x2,"%g");
	SAVE_PARAM("y2",_y2,"%g");
	SAVE_PARAM("clipLeft",_clipLeft,"%d");
	SAVE_PARAM("clipRight",_clipRight,"%d");
	SAVE_PARAM("clipTop",_clipTop,"%d");
	SAVE_PARAM("clipBottom",_clipBottom,"%d");
}

/*! @file
 * @brief Implements VisionObjectEvent, which provides information about objects recognized in the camera image
 * @author alokl (Creator)
 * @author Ignacio Herrero Reder &lt; nhr at dte uma es &gt; (VisionObjectInfo Boundary Box - bug 74)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_4 $
 * $Revision: 1.9 $
 * $State: Exp $
 * $Date: 2005/08/07 04:11:03 $
 */
