//-*-c++-*-
#ifndef INCLUDED_TextMsgEvent_h
#define INCLUDED_TextMsgEvent_h

#include "EventBase.h"

//! Extends EventBase to also include actual message text
class TextMsgEvent : public EventBase {
 public:
	//! Constructor
  TextMsgEvent() : EventBase(EventBase::textmsgEGID,(unsigned int)-1, EventBase::statusETID,0),_text("")/*,_token(0)*/ {  }

  //! Constructor, pass a text msg
  TextMsgEvent(const std::string& text) : EventBase(EventBase::textmsgEGID,(unsigned int)-1, EventBase::statusETID,0),_text(text)/*,_token(0)*/ { }
  
	virtual EventBase* clone() const { return new TextMsgEvent(*this); }

	virtual unsigned int getClassTypeID() const { return makeClassTypeID("TXTM"); }

  std::string getText() const { return _text; } //!< returns the text
  TextMsgEvent& setText(const std::string& text) { _text=text; return *this; } //!< sets the text
  
  //int getToken() const { return _token; } //!< returns the token
  //TextMsgEvent& setToken(int token) { _token=token; return *this;} //!< sets the token
	
	std::string getDescription(bool showTypeSpecific=true, unsigned int verbosity=0) const;
	
	virtual unsigned int getBinSize() const;
	virtual unsigned int LoadBinaryBuffer(const char buf[], unsigned int len);
	virtual unsigned int SaveBinaryBuffer(char buf[], unsigned int len) const;
	virtual void LoadXML(xmlNode* node);
	virtual void SaveXML(xmlNode * node) const;
	
 protected:
  std::string _text; //!< the unmodified arguments passed to the command
  //int _token;      //!< for future expansion, to support centralized parsing
};

/*! @file
 * @brief Describes TextMsgEvent, which extends EventBase to also include actual message text
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_4 $
 * $Revision: 1.12 $
 * $State: Exp $
 * $Date: 2005/06/29 22:03:35 $
 */

#endif
