#include "PaceTargetsMachine.h"
#include "Behaviors/Transition.h"
#include "Behaviors/Nodes/WalkToTargetNode.h"
#include "Behaviors/Nodes/WalkNode.h"
#include "ExploreMachine.h"
#include "Behaviors/Transitions/TimeOutTrans.h"
#include "Behaviors/Transitions/VisualTargetTrans.h"
#include "Behaviors/Nodes/OutputNode.h"
#include "Behaviors/Nodes/MotionSequenceNode.h"
#include "Behaviors/Nodes/GroupNode.h"
#include "Sound/SoundManager.h"

void PaceTargetsMachine::setup() {
	StateNode::setup();

	const float turnAroundSpeed=1; //1 rad/sec
	//explore and chase have their own built-in speeds

	//*****  NODE SETUP *****//

	//turns in place
	WalkNode * turnAround = new WalkNode(0,0,turnAroundSpeed);
	turnAround->setName(getName()+"::TurnAround");
	addNode(turnAround);

	//two nodes running together -- explore will wander around, panhead will look around
	GroupNode * explGrp = new GroupNode(getName()+"::ExplGroup");
	addNode(explGrp);
	{
		ExploreMachine * explore = new ExploreMachine(explGrp->getName()+"::Explore");
		explGrp->addNode(explore);
		SmallMotionSequenceNode * panhead = new SmallMotionSequenceNode(explGrp->getName()+"::PanHead","pan_head.mot",true);
		explGrp->addNode(panhead);
	}

	//follow the ball
	WalkToTargetNode * chase = new WalkToTargetNode(ProjectInterface::visPinkBallSID);
	chase->setName(getName()+"::Chase");
	addNode(chase);


	//*****  TRANSITION SETUP *****//

	Transition * tmptrans=NULL;

	//if it sees pink, chase it
	explGrp->addTransition(tmptrans=new VisualTargetTrans(chase,ProjectInterface::visPinkBallSID));
	tmptrans->setSound("cutey.wav");

	//if you lose it, explore some more
	chase->addTransition(tmptrans=chase->newDefaultLostTrans(explGrp));
	tmptrans->setSound("whimper.wav");
	
	//if you get there, turn around
	chase->addTransition(tmptrans=chase->newDefaultCloseTrans(turnAround));
	tmptrans->setSound("fart.wav");
	
	//once you've turned around, explore
	turnAround->addTransition(tmptrans=new TimeOutTrans(explGrp,(unsigned int)(M_PI/turnAroundSpeed*1000))); //turn 180 degrees (aka PI radians)
	tmptrans->setSound("barkmed.wav");
	
	//preload the sounds so we don't pause on tranisitions
	sndman->LoadFile("cutey.wav");
	sndman->LoadFile("barkmed.wav");
	sndman->LoadFile("whimper.wav");
	sndman->LoadFile("fart.wav");

	//starts out exploring
	start=explGrp;
}

void PaceTargetsMachine::DoStart() {
	StateNode::DoStart();
	start->DoStart();
}

void PaceTargetsMachine::teardown() {
	//release the sounds
	sndman->ReleaseFile("cutey.wav");
	sndman->ReleaseFile("barkmed.wav");
	sndman->ReleaseFile("whimper.wav");
	sndman->ReleaseFile("fart.wav");
	StateNode::teardown();
}

/*! @file
 * @brief Implements PaceTargetsMachine, a StateMachine for walking back and forth between two visual targets
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_4 $
 * $Revision: 1.18 $
 * $State: Exp $
 * $Date: 2005/08/03 19:11:58 $
 */

