#include "ChaseBallBehavior.h"
#include "Events/EventRouter.h"
#include "Events/VisionObjectEvent.h"
#include "Shared/WorldState.h"
#include "Motion/HeadPointerMC.h"
#include "Motion/WalkMC.h"
#include "Shared/WMclass.h"
#include "Shared/ProjectInterface.h"

//! Converts degrees to radians
inline double DtoR(double deg) { return (deg/180.0*M_PI); }

void ChaseBallBehavior::DoStart() {
	BehaviorBase::DoStart();
	headpointer_id = motman->addPersistentMotion(SharedObject<HeadPointerMC>());
	walker_id = motman->addPersistentMotion(SharedObject<WalkMC>());
	erouter->addListener(this,EventBase::visObjEGID,ProjectInterface::visPinkBallSID);
}

void ChaseBallBehavior::DoStop() {
	erouter->removeListener(this);
	motman->removeMotion(headpointer_id);
	motman->removeMotion(walker_id);
	BehaviorBase::DoStop();
}

//this could be cleaned up event-wise (only use a timer when out of view)
void ChaseBallBehavior::processEvent(const EventBase& event) {
  WMreg(chase_ball_behavior);
  WMvari_(float, horiz, 0, chase_ball_behavior);
  WMvari_(float, vert, 0, chase_ball_behavior);

	if(event.getGeneratorID()==EventBase::visObjEGID && event.getTypeID()==EventBase::statusETID) {
		horiz=static_cast<const VisionObjectEvent*>(&event)->getCenterX();
		vert=static_cast<const VisionObjectEvent*>(&event)->getCenterY();
	}

	WalkMC * walker = (WalkMC*)motman->checkoutMotion(walker_id);
	if(state->outputs[HeadOffset+PanOffset]<-.05 || state->outputs[HeadOffset+PanOffset]>.05)
		walker->setTargetVelocity(100,0,state->outputs[HeadOffset+PanOffset]);
	else
		walker->setTargetVelocity(160,0,0);
	motman->checkinMotion(walker_id);
	  
	//		cout << inview << ' ' << horiz << ' ' << vert << endl;

	double tilt=state->outputs[HeadOffset+TiltOffset]-vert*M_PI/7.5;
	double pan=state->outputs[HeadOffset+PanOffset]-horiz*M_PI/6;
	if(tilt<DtoR(-20))
		tilt=DtoR(-20);
	if(tilt>DtoR(40))
		tilt=DtoR(40);
	if(pan>DtoR(80))
		pan=DtoR(80);
	if(pan<DtoR(-80))
		pan=DtoR(-80);
	HeadPointerMC * headpointer= (HeadPointerMC*)motman->checkoutMotion(headpointer_id);
	headpointer->setJoints(tilt,pan,0);
	motman->checkinMotion(headpointer_id);
}
			
/*! @file
 * @brief Implements ChaseBallBehavior, which runs around after whatever the dog sees
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_4 $
 * $Revision: 1.11 $
 * $State: Exp $
 * $Date: 2004/10/17 01:16:10 $
 */


