//-*-c++-*-
#ifndef INCLUDED_EventLogger_h_
#define INCLUDED_EventLogger_h_

#include "ControlBase.h"
#include "Events/EventListener.h"
#include <fstream>

class FilterBankGenerator;
class BehaviorBase;

//! allows logging of events to the console or a file
class EventLogger : public ControlBase, public EventListener {
public:
	//!constructor
	EventLogger();
	virtual ~EventLogger();

	//!opens a custom (embedded) menu to toggle individual EGIDs
	virtual ControlBase* doSelect();
	
	virtual void refresh();

	//!sends all events received to stdout and/or logfile
	virtual void processEvent(const EventBase& event);

	//!returns #logSocket
	static class Socket* getLogSocket() { return logSocket; }
	
	//! returns #port
	static int getLogSocketPort() { return port; }
	
	//! sets #port
	static void setLogSocketPort(int p) { port=p; }

	//! send the current camera image over the log socket
	static void logImage(FilterBankGenerator& fbg, unsigned int layer, unsigned int channel, const BehaviorBase* source=NULL);

	//! send a string over the log socket
	static void logMessage(std::string msg, const BehaviorBase* source=NULL, const char* icon=NULL, unsigned int placement=0);
	
	//! request that the desktop side take a picture with the webcam (if available)
	static void logWebcam(const BehaviorBase* source=NULL);
	
protected:
	virtual void clearSlots();

	//!sets the status char of slot @a i to @a c
	void setStatus(unsigned int i, char c);

	//!checks to see if logfilePath differs from the StringInputControl's value and switches it if it is
	void checkLogFile();
	
	//!address of the logfile, if any (empty string is no logfile)
	std::string logfilePath;

	//!if a filename is given, events are logged to here
	std::ofstream logfile;
	
	//! events which are logged will be sent over this port in an xml format.  See eventlog.dtd in the docs directory
	static class Socket* logSocket;
	
	//! port number #logSocket will listen on
	static int port;
	
	//! reference count for #logSocket -- when this hits 0, close the socket
	static unsigned int logSocketRefCount;
	
	//!controls the level of verbosity - currently 0 through 2
	unsigned int verbosity;
};

/*! @file
 * @brief Describes EventLogger, which allows logging of events to the console or a file
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_4 $
 * $Revision: 1.7 $
 * $State: Exp $
 * $Date: 2005/06/01 05:47:44 $
 */

#endif
