/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.test;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPConnectMode;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.TestCase;

public abstract class FTPTestCase
extends TestCase {
    private static String cvsId = "@(#)$Id: FTPTestCase.java,v 1.2 2003/05/31 14:54:05 bruceb Exp $";
    protected PrintWriter log;
    protected FTPClient ftp;
    protected String host;
    protected String user;
    protected String password;
    protected FTPConnectMode connectMode;
    protected int timeout;
    protected String testdir;
    protected String remoteTextFile;
    protected String localTextFile;
    protected String remoteBinaryFile;
    protected String localBinaryFile;
    protected String localEmptyFile;
    protected String remoteEmptyFile;
    protected String remoteEmptyDir;

    public FTPTestCase() {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream("test.properties"));
        }
        catch (IOException ex) {
            System.out.println("Failed to open test.properties");
        }
        this.host = props.getProperty("ftptest.host");
        this.user = props.getProperty("ftptest.user");
        this.password = props.getProperty("ftptest.password");
        String connectMode = props.getProperty("ftptest.connectmode");
        this.connectMode = connectMode.equalsIgnoreCase("active") ? FTPConnectMode.ACTIVE : FTPConnectMode.PASV;
        String timeout = props.getProperty("ftptest.timeout");
        this.timeout = Integer.parseInt(timeout);
        this.testdir = props.getProperty("ftptest.testdir");
        this.localTextFile = props.getProperty("ftptest.file.local.text");
        this.remoteTextFile = props.getProperty("ftptest.file.remote.text");
        this.localBinaryFile = props.getProperty("ftptest.file.local.binary");
        this.remoteBinaryFile = props.getProperty("ftptest.file.remote.binary");
        this.localEmptyFile = props.getProperty("ftptest.file.local.empty");
        this.remoteEmptyFile = props.getProperty("ftptest.file.remote.empty");
        this.remoteEmptyDir = props.getProperty("ftptest.dir.remote.empty");
    }

    protected void setUp() throws Exception {
        this.log = new PrintWriter(new FileWriter(this.getLogName(), true));
    }

    protected void tearDown() throws Exception {
        this.log.close();
    }

    protected void connect() throws Exception {
        this.ftp = new FTPClient(this.host, 21);
        this.ftp.debugResponses(true);
        this.ftp.setLogStream(this.log);
    }

    protected void login() throws Exception {
        this.ftp.login(this.user, this.password);
    }

    protected String generateRandomFilename() {
        Date now = new Date();
        Long ms = new Long(now.getTime());
        return ms.toString();
    }

    protected void assertIdentical(byte[] buf1, byte[] buf2) throws Exception {
        Assert.assertEquals((int)buf1.length, (int)buf2.length);
        int i = 0;
        while (i < buf1.length) {
            Assert.assertEquals((byte)buf1[i], (byte)buf2[i]);
            ++i;
        }
    }

    protected void assertIdentical(String file1, String file2) throws Exception {
        File f1 = new File(file1);
        File f2 = new File(file2);
        this.assertIdentical(f1, f2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertIdentical(File file1, File file2) throws Exception {
        BufferedInputStream is1 = null;
        BufferedInputStream is2 = null;
        try {
            Assert.assertEquals((long)file1.length(), (long)file2.length());
            this.log.println("Identical size [" + file1.getName() + "," + file2.getName() + "]");
            is1 = new BufferedInputStream(new FileInputStream(file1));
            is2 = new BufferedInputStream(new FileInputStream(file2));
            int ch1 = 0;
            int ch2 = 0;
            while ((ch1 = is1.read()) != -1 && (ch2 = is2.read()) != -1) {
                Assert.assertEquals((int)ch1, (int)ch2);
            }
            this.log.println("Contents equal");
        }
        catch (IOException ex) {
            Assert.fail((String)("Caught exception: " + ex.getMessage()));
        }
        finally {
            if (is1 != null) {
                is1.close();
            }
            if (is2 != null) {
                is2.close();
            }
        }
    }

    protected abstract String getLogName();
}

