import java.awt.image.*;
import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.util.*;
import java.awt.geom.*;
import java.io.*;

public class VisionTrain extends JFrame {
  int height=700, width=700;
  public ColorControlPanel controlPanel;
  public static ColorConverter colorConverter;

  public static void main(String args[]) {
    if (args.length<1) {
			usageAndExit();
    }
    colorConverter=new ColorConverter() {
      public final float[] getColor(int r, int g, int b) {
        float[] hsb=new float[3];
        Color.RGBtoHSB(r, g, b, hsb);
        float[] res=new float[2];
        res[0]=hsb[0];
        res[1]=hsb[1];
        return res;
      }
    };
    
		boolean isRGB=true;
		if(args[0].equals("-isRGB"))
			isRGB=true;
		else if(args[0].equals("-isYUV"))
			isRGB=false;
		else {
			System.out.println(args[0]+" is not valid color mode");
			usageAndExit();
		}
		
		String files[]=new String[args.length-1];
		for(int i=0; i<files.length; i++)
			files[i]=args[i+1];

    VisionTrain visionTrain=new VisionTrain(isRGB,files);
    visionTrain.addWindowListener(new WindowAdapter() {
        public void windowClosing(WindowEvent e) { System.exit(0); } });
    visionTrain.controlPanel.addWindowListener(new WindowAdapter() {
        public void windowClosing(WindowEvent e) { System.exit(0); } });
  }

	public static void usageAndExit() {
		System.out.println("usage: java VisionTrain (-isRGB|-isYUV) filename [filename ..]");
		System.out.println("       Using YUV images is recommended.");
		System.out.println("       A mode must be specified.");
		System.exit(1);
	}
 
  public VisionTrain(boolean isRGB, String files[]) {
		System.out.println("Interpreting images as "+(isRGB?"RGB":"YUV")+" colorspace");
    ImageShow imageShow=new ImageShow(isRGB,files);
    
    setBackground(Color.black);
    setSize(new Dimension(width, height));
    Container root=this.getContentPane();
    root.setLayout(new BorderLayout());
    TrainCanvas trainCanvas=new TrainCanvas();
    root.add(trainCanvas);
    addKeyListener(trainCanvas);
    show();

    controlPanel=new ColorControlPanel(trainCanvas, imageShow);

    ImageData imageData=new ImageData();

		//Thanks to martin.mueller at mni.fh-giessen.de for the bug fix:
		if(isRGB)
			imageData.loadFullRGBFilesAsRGB(files);
		else 
			imageData.loadFullYUVFilesAsRGB(files);
    trainCanvas.plotImage(imageData.getHS(), imageData.getPixels());
  }
}

