import java.awt.image.*;
import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.util.*;
import java.awt.geom.*;
import java.io.*;

class ColorControlPanel extends JFrame implements ActionListener,
    ListSelectionListener {
  Container root;
  JTextField colorname;
  JList colorlist;
  DefaultListModel list;
  JScrollPane colorlistscroll;
  JButton remove, clear, save, imageview, invert;
  int curcolor;

  TrainCanvas trainCanvas;
  ImageShow imageShow;

  public ColorControlPanel (TrainCanvas trainCanvas, ImageShow imageShow) {
    this.trainCanvas=trainCanvas;
    this.imageShow=imageShow;
    imageShow.addMouseMotionListener(trainCanvas);
    imageShow.addMouseListener(trainCanvas);

    setSize(new Dimension (120,350));
    setLocation(800,50);

    setResizable(false);
    root=this.getContentPane();
    root.setLayout(new FlowLayout());

    colorname=new JTextField(10);
    colorname.addActionListener(this);
    root.add(colorname);

    list=new DefaultListModel();
    colorlist=new JList(list);
    colorlist.setFixedCellWidth(90);
    colorlist.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
    colorlist.addListSelectionListener(this);

    colorlistscroll=new JScrollPane(colorlist,
                       JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
                       JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
    root.add(colorlistscroll);

    remove=new JButton("remove");
    remove.addActionListener(this);
    root.add(remove);

    clear=new JButton("clear");
    clear.addActionListener(this);
    root.add(clear);

    invert=new JButton("invert");
    invert.addActionListener(this);
    root.add(invert);

    imageview=new JButton("image view");
    imageview.addActionListener(this);
    root.add(imageview);

    save=new JButton("save");
    save.addActionListener(this);
    root.add(save);

    setCurColor(-1);
    show();
  }

  public void actionPerformed(ActionEvent e) {
    if (e.getSource()==save) {
      JFileChooser chooser=new JFileChooser();
      chooser.setSelectedFile(new File("default.tm"));
      int returnval=chooser.showSaveDialog(save);
      if (returnval==JFileChooser.APPROVE_OPTION) {
        trainCanvas.save(chooser.getSelectedFile().getAbsolutePath());
      }
    } else if (e.getSource()==clear) {
      trainCanvas.clear();
    } else if (e.getSource()==invert) {
      trainCanvas.invert();
    } else if (e.getSource()==remove) {
      trainCanvas.remove((String)list.get(curcolor));
      list.remove(curcolor);
      setCurColor(-1);
    } else if (e.getSource()==imageview) {
      imageShow.show();
    } else if (e.getSource()==colorname) {
      String s=e.getActionCommand();
      if (!s.equals("")) {
        int i=0;
        while (i<list.getSize() && !list.get(i).equals(s)) {
          i++;
        }
        if (i==list.getSize()) {
          list.addElement(s);
          colorname.setText("");
          colorlist.setSelectedIndex(i);
        }
      }
    }
  }

  public void valueChanged(ListSelectionEvent e) {
    if (!e.getValueIsAdjusting()) {
      setCurColor(colorlist.getSelectedIndex());
    }
  }

  void setCurColor(int index) {
    curcolor=index;

    if (index<0) {
      remove.setEnabled(false);
      clear.setEnabled(false);
      trainCanvas.setCurColor(null);
    } else {
      remove.setEnabled(true);
      clear.setEnabled(true);
      trainCanvas.setCurColor((String)list.get(curcolor));
    }
  }
}
