
/** @file EasyTrain.java
 *  @brief
 *
 *  Color segmentation tool for the Tekkotsu framework based on the VisionTrain and TileTrain tools
 *
 *	@author editted by: Eric Durback
 *  @bug No known bugs.





** NOTE FOR LINUX USERS **
If your using linux, and you are receiving warnings about preferences, look at
the installation notes for java on linux at the link below will help
http://java.sun.com/j2se/1.5.0/install-linux.html 
**************************


TODO

1. array of thumbnails - long term

2. loading with incorrect images
*/


import java.awt.image.*;
import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.util.*;
import java.awt.geom.*;
import java.io.*;
import java.util.prefs.Preferences;

public class EasyTrain extends JFrame implements ComponentListener
{
	int height=700, width=700;
	public ColorControlPanel controlPanel;
	public static ColorConverter colorConverter;

	static Preferences prefs = Preferences.userNodeForPackage(EasyTrain.class);

	public static void main(String args[]) 
	{
		if (args.length<1) 
		{
			usageAndExit();
		}

		colorConverter=new ColorConverter() 
		{
			public final float[] getColor(int r, int g, int b) 
			{
				float[] hsb=new float[3];
				Color.RGBtoHSB(r, g, b, hsb);
				float[] res=new float[2];
				res[0]=hsb[0];
				res[1]=hsb[1];
				return res;
			}
		};

		boolean isRGB=true;
		if(args[0].equals("-isRGB"))
			isRGB=true;
		else if(args[0].equals("-isYUV"))
			isRGB=false;
		else 
		{
			System.out.println(args[0]+" is not valid color mode");
			usageAndExit();
		}
			//get picture files
		String files[]=new String[args.length-1];
		for(int i=0; i<files.length; i++)
			files[i]=args[i+1];
			
		//init training tool
		EasyTrain easyTrain = new EasyTrain(isRGB,files);
		
		easyTrain.addWindowListener(new WindowAdapter() {
		    public void windowClosing(WindowEvent e) { System.exit(0); } });
		easyTrain.controlPanel.addWindowListener(new WindowAdapter() {
		    public void windowClosing(WindowEvent e) { System.exit(0); } });
	}

	public static void usageAndExit() 
	{
		System.out.println("usage: java EasyTrain (-isRGB|-isYUV) filename [filename ..]");
		System.out.println("       Using YUV images is recommended.");
		System.out.println("       A mode must be specified.");
		System.exit(1);
	}

	public EasyTrain(boolean isRGB, String files[]) 
	{
		System.out.println("Interpreting images as "+(isRGB?"RGB":"YUV")+" colorspace");

		//opening image panel

		try{
		if(prefs.keys() == null) //no prefs yet
		{
			setDefaultPrefs();    
		}
		}catch(Exception e){}

		setBackground(Color.black);
		setSize(new Dimension(width, height));
		setLocation(prefs.getInt("EasyTrain.location.x",50),prefs.getInt("EasyTrain.location.y",50));
		setTitle("Color Spectrum");
		Container root=this.getContentPane();
		root.setLayout(new BorderLayout());

		ImageData imageData=new ImageData(files.length);
		ImageData YUVimageData = new ImageData(files.length);

		//Thanks to martin.mueller at mni.fh-giessen.de for the bug fix:
		if(isRGB)
		{
			imageData.loadRGBFileAsRGB(files[0]);
			YUVimageData.loadRGBFileAsYUV(files[0]);
		}
		else
		{ 
			imageData.loadYUVFileAsRGB(files[0]);
			YUVimageData.loadYUVFileAsYUV(files[0]);
		}

		ImageShowArea imageShow=new ImageShowArea(isRGB,files,imageData);
		
		SegmentedImage segImage = new SegmentedImage(YUVimageData,imageShow);
		segImage.setSize(imageShow.getSize());

		HelpBox helpBox = new HelpBox();

		TrainCanvas trainCanvas=new TrainCanvas(segImage, imageShow, imageData, YUVimageData, controlPanel, helpBox, files);
		root.add(trainCanvas);
		
		addComponentListener(this);
		setVisible(true);
		trainCanvas.plotImage(imageData.getSpecialHS(), imageData.getSpecialPixels());

		controlPanel=new ColorControlPanel(trainCanvas, imageShow);
		
		trainCanvas.setControlPanel(controlPanel);
		imageShow.setTrainCanvas(trainCanvas);
		

		imageShow.setVisible(true);
		segImage.toFront();
		segImage.repaint();
	}

	public void componentResized(ComponentEvent e) {}
	public void componentHidden(ComponentEvent e) {}
	
	public void componentMoved(ComponentEvent e)
	{ 	
		prefs.putInt("EasyTrain.location.x",getLocation().x);
		prefs.putInt("EasyTrain.location.y",getLocation().y);
	}
	public void componentShown(ComponentEvent e) { }

	public void setDefaultPrefs()
	{
		prefs.putInt("EasyTrain.location.x",10);
		prefs.putInt("EasyTrain.location.y",10);

		prefs.putInt("ColorControlPanel.location.x",780);
		prefs.putInt("ColorControlPanel.location.y",50);

		prefs.putInt("HelpBox.location.x",100);
		prefs.putInt("HelpBox.location.y",100);

		prefs.putInt("ImageShowArea.location.x",50);
		prefs.putInt("ImageShowArea.location.y",200);

		prefs.putInt("SegmentedImage.location.x",400);
		prefs.putInt("SegmentedImage.location.y",200);

	}  
  
}




