#include "SoundPlay.h"
#include "SharedGlobals.h"
#include "Main.h"
#include "IPC/RegionRegistry.h"
#include "IPC/MessageReceiver.h"
#include "Events/EventRouter.h"

SoundPlay::SoundPlay()
	: Process(getID(),getClassName()),
		requests(ipc_setup->registerRegion(getSoundPlayID(),sizeof(sim::SoundPlayQueue_t))),
		events(ipc_setup->registerRegion(Main::getEventsID(),sizeof(sim::EventQueue_t))),
		soundmanager(ipc_setup->registerRegion(getSoundManagerID(),sizeof(SoundManager))),
		etrans(NULL), sndrecv(NULL)
{
	new (&(*requests)) sim::SoundPlayQueue_t;
	new (&(*soundmanager)) SoundManager();
	sndman=&(*soundmanager);

	//need to register any events which we might be sending
	EventTranslator::registerPrototype<EventBase>(); //Sound only sends the basic event type
}

SoundPlay::~SoundPlay() {
	delete etrans;
	etrans=NULL;
	MotionManager::setTranslator(NULL);
}

void SoundPlay::DoStart() {
	Process::DoStart();
	//These are constructed by other processes, so need to wait
	//until the construction runlevel is complete before we access them
	etrans=new IPCEventTranslator(*events);
	MotionManager::setTranslator(etrans); //although SoundPlay shouldn't use any motions...

	// Set up Event Translator to trap and send events to main process
	//send everything over except erouter events
	for(unsigned int i=0; i<EventBase::numEGIDs; i++)
		if(i!=EventBase::erouterEGID)
			erouter->addTrapper(etrans,static_cast<EventBase::EventGeneratorID_t>(i));
	
	sndrecv=new MessageReceiver(*requests,gotSnd);
}

void SoundPlay::DoStop() {
	sndrecv->finish();
	delete sndrecv;
	sndrecv=NULL;
	sndman->StopPlay();
	erouter->removeTrapper(etrans);
	Process::DoStop();
}


/*! @file
 * @brief 
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_4_1 $
 * $Revision: 1.3 $
 * $State: Exp $
 * $Date: 2005/06/29 22:06:41 $
 */

