//-*-c++-*-
#ifndef INCLUDED_Simulator_h_
#define INCLUDED_Simulator_h_

#include "Process.h"
#include "sim.h"
#include "IPC/SharedObject.h"
#include "SharedGlobals.h"
#include "Shared/plist.h"
#include "LoadImageThread.h"

class Simulator : public Process,  public plist::PrimitiveListener, public MessageQueueBase::StatusListener {
public:
	//! constructor
	Simulator();
	
	~Simulator();

	virtual void DoStart();
	virtual void DoStop();
	virtual void run();
	
	static const char * getClassName() { return "Simulator"; }
	static ProcessID::ProcessID_t getID() { return ProcessID::SimulatorProcess; }
	
	static const char * getCameraQueueID() { return "CameraData"; }
	static const char * getSensorQueueID() { return "SensorData"; }

	virtual void plistValueChanged(const plist::PrimitiveBase& pl);

	virtual void messagesRead(MessageQueueBase& mq, unsigned int n);

protected:
	void processRunlevel(SharedGlobals::runlevel_t curLevel);
	void cmdLoad(const std::vector<std::string>& args);
	void cmdSave(const std::vector<std::string>& args);
	void cmdRunlevel(const std::vector<std::string>& args, SharedGlobals::runlevel_t curLevel);
	void cmdSet(const std::vector<std::string>& args);
	void cmdRun(const std::vector<std::string>& args, SharedGlobals::runlevel_t curLevel, bool isRelative);
	void cmdRun(const std::vector<std::string>& args, SharedGlobals::runlevel_t curLevel);
	void cmdPause(const std::vector<std::string>& args, SharedGlobals::runlevel_t curLevel);
	void cmdHelp(const std::vector<std::string>& args);
	
	SharedObject<sim::CameraQueue_t> cameraQueue;
	SharedObject<sim::SensorQueue_t> sensorQueue;
	LoadImageThread vision;
	LoadImageThread sensors;
	plist::Primitive<int> visionLayer;

private:
	Simulator(const Simulator&); //!< don't call (copy constructor)
	Simulator& operator=(const Simulator&); //!< don't call (assignment operator)
};

/*! @file
 * @brief Defines Simulator, which DESCRIPTION
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_4_1 $
 * $Revision: 1.5 $
 * $State: Exp $
 * $Date: 2005/08/03 06:37:42 $
 */

#endif
