//-*-c++-*-
#ifndef INCLUDED_SimConfig_h_
#define INCLUDED_SimConfig_h_

#include "Shared/plist.h"
#include "SharedGlobals.h"

//! description of SimConfig
class SimConfig : public plist::Dictionary {
public:
	SimConfig() : 
		cmdPrompt("sim >"),
		initSimTime(0),
		tgtRunlevel(SharedGlobals::RUNNING, SharedGlobals::runlevel_names, SharedGlobals::NUM_RUNLEVELS),
		runTo(-1U),
		lastfile()
	{
		setUnusedWarning(false);
		addEntry("InitialTime",initSimTime,"The value to initialize the simulator's clock (in milliseconds)");
		addEntry("InitialRunlevel",tgtRunlevel,"Specifies how far startup should proceed before pausing for user interaction.\nThis value only affects startup, and setting this value from the simulator command prompt will have no effect.  (Use the 'runlevel' command instead.)");
		addEntry("RunToTime",runTo,"Time at which to automatically set Speed to 0, from either realtime or non-realtime mode");
	}
	
	std::string cmdPrompt; //!< not persistently stored -- [re]set by main(...) on each run
	plist::Primitive<unsigned int> initSimTime;
	plist::NamedEnumeration<SharedGlobals::runlevel_t> tgtRunlevel;
	plist::Primitive<unsigned int> runTo;

	void setLastFile(const std::string& str) const {
		lastfile=str;
	}
	const std::string& getLastFile() const {
		return lastfile;
	}
	virtual	unsigned int LoadFile(const char* filename) {
		lastfile=filename;
		return Dictionary::LoadFile(filename);
	}
	virtual unsigned int SaveFile(const char* filename) const {
		lastfile=filename;
		return Dictionary::SaveFile(filename);
	}
	
protected:
	mutable std::string lastfile;
};

/*! @file
 * @brief 
 * @author Ethan Tira-Thompson (ejt) (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_4_1 $
 * $Revision: 1.3 $
 * $State: Exp $
 * $Date: 2005/07/26 03:07:36 $
 */

#endif
