#include "Motion.h"
#include "Main.h"
#include "SoundPlay.h"
#include "IPC/RegionRegistry.h"
#include "IPC/MessageReceiver.h"
#include "Motion/Kinematics.h"
#include "Wireless/Wireless.h"
#include "Events/EventRouter.h"

#include "Events/EventBase.h"
#include "Events/LocomotionEvent.h"
#include "Events/TextMsgEvent.h"
#include "Events/VisionObjectEvent.h"

Motion::Motion()
	: Process(getID(),getClassName()),
	sounds(ipc_setup->registerRegion(SoundPlay::getSoundPlayID(),sizeof(sim::SoundPlayQueue_t))),
	motions(ipc_setup->registerRegion(getMotionCommandID(),sizeof(sim::MotionCommandQueue_t))),
	events(ipc_setup->registerRegion(Main::getEventsID(),sizeof(sim::EventQueue_t))),
	motionmanager(ipc_setup->registerRegion(getMotionManagerID(),sizeof(MotionManager))),
	soundmanager(ipc_setup->registerRegion(SoundPlay::getSoundManagerID(),sizeof(SoundManager))),
	worldstate(ipc_setup->registerRegion(Main::getWorldStateID(),sizeof(WorldState))),
	etrans(NULL), mcrecv(NULL), wireless_thread()
{
	new (&(*motions)) sim::MotionCommandQueue_t;
	new (&(*motionmanager)) MotionManager();
	motman=&(*motionmanager);
	motman->InitAccess(*motions);
	sndman=&(*soundmanager);
	state=&(*worldstate);
	
	//Setup wireless
	wireless = new Wireless();
	sout=wireless->socket(SocketNS::SOCK_STREAM,Wireless::WIRELESS_DEF_RECV_SIZE,Wireless::WIRELESS_DEF_SEND_SIZE*12);
	serr=wireless->socket(SocketNS::SOCK_STREAM,Wireless::WIRELESS_DEF_RECV_SIZE,Wireless::WIRELESS_DEF_SEND_SIZE*4);
	wireless->setDaemon(sout);
	wireless->setDaemon(serr);
	serr->setFlushType(SocketNS::FLUSH_BLOCKING);
	sout->setTextForward();
	serr->setForward(sout);

	//Setup Kinematics
	kine=new Kinematics();
	
	//need to register any events which we might be sending or receiving
	EventTranslator::registerPrototype<EventBase>();
	EventTranslator::registerPrototype<LocomotionEvent>();
	EventTranslator::registerPrototype<TextMsgEvent>();
	EventTranslator::registerPrototype<VisionObjectEvent>();

	//EventRouter and Config are set up for all processes by main() before fork
}

Motion::~Motion() {
	delete etrans;
	etrans=NULL;
	MotionManager::setTranslator(NULL);
}

void Motion::DoStart() {
	Process::DoStart();
	//These are constructed by other processes, so need to wait
	//until the construction runlevel is complete before we access them
	sndman->InitAccess(*sounds);
	etrans=new IPCEventTranslator(*events);
	MotionManager::setTranslator(etrans);
	
	// Set up Event Translator to trap and send events to main process
	//send everything over except erouter events
	for(unsigned int i=0; i<EventBase::numEGIDs; i++)
		if(i!=EventBase::erouterEGID)
			erouter->addTrapper(etrans,static_cast<EventBase::EventGeneratorID_t>(i));
	
	wireless_thread.start();
	mcrecv=new MessageReceiver(*motions,gotMC);
}


void Motion::run() {
	Process::run();
}

void Motion::DoStop() {
	wireless_thread.stop();
	wireless->wakeup();
	wireless_thread.join();

	mcrecv->finish();
	delete mcrecv;
	mcrecv=NULL;
	erouter->removeTrapper(etrans);
	motman->RemoveAccess();
	Process::DoStop();
}

/*! @file
 * @brief 
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_4_1 $
 * $Revision: 1.3 $
 * $State: Exp $
 * $Date: 2005/06/29 22:06:41 $
 */

