//-*-c++-*-
#ifndef INCLUDED_Main_h_
#define INCLUDED_Main_h_

#include "Process.h"
#include "sim.h"
#include "IPC/SharedObject.h"
#include "SharedGlobals.h"
#include "Motion/MotionManager.h"
#include "Sound/SoundManager.h"
#include "Shared/WorldState.h"
class MessageReceiver;

class Main : public Process {
public:
	//! constructor
	Main();
	//! destructor
	~Main();

	virtual void DoStart();
	virtual void DoStop();
	virtual void run();

	//! Will return true if calls to advanceVision() and advanceSensor() will be heeded
	static bool canManuallyAdvance();

	//! Use this to request the next vision frame be sent
	static void advanceVision();

	//! Use this to request the next sensor frame be sent
	static void advanceSensor();
	
	static const char* getClassName() { return "Main"; }
	static ProcessID::ProcessID_t getID() { return ProcessID::MainProcess; }
	
	static const char * getEventsID() { return "MainEvents"; }
	static const char * getWorldStateID() { return "WorldState"; }
	
protected:
	SharedObject<sim::SoundPlayQueue_t> sounds;
	SharedObject<sim::MotionCommandQueue_t> motions;
	SharedObject<sim::EventQueue_t> events;
	SharedObject<sim::CameraQueue_t> cameraFrames;
	SharedObject<sim::SensorQueue_t> sensorFrames;
	SharedObject<MotionManager> motionmanager;
	SharedObject<SoundManager> soundmanager;
	SharedObject<WorldState> worldstate;
	MessageReceiver * visrecv;
	MessageReceiver * sensrecv;
	MessageReceiver * evtrecv;
	bool visionRead;
	bool sensorRead;
	WirelessThread wireless_thread;

	static bool gotCamera(RCRegion* msg);
	static bool gotEvent(RCRegion* msg);
	RCRegion * curimg;
	
private:
	Main(const Main&); //!< don't call (copy constructor)
	Main& operator=(const Main&); //!< don't call (assignment operator)
};

/*! @file
 * @brief Defines Main, which DESCRIPTION
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_4_1 $
 * $Revision: 1.6 $
 * $State: Exp $
 * $Date: 2005/07/06 22:53:10 $
 */

#endif
