//-*-c++-*-
#ifndef INCLUDED_LoadImageThread_h_
#define INCLUDED_LoadImageThread_h_

#include "LoadFileThread.h"

//! description of LoadImageThread
class LoadImageThread : public LoadFileThread {
public:
	LoadImageThread(std::string source, std::string filter, float fps, MessageQueueBase& messages);
	~LoadImageThread();

	virtual bool loadFile(const std::string& file, RCRegion*& data);
	
protected:
	struct jpeg_decompress_struct* cinfo; //!< used to interface with libjpeg - holds compression parameters and state
	struct jpeg_error_mgr* jerr;          //!< used to interface with libjpeg - gives us access to error information
	unsigned int frameIndex; //!< serial number, incremented for each frame loaded
	
private:
	LoadImageThread(const LoadImageThread&); //!< don't call
	LoadImageThread& operator=(const LoadImageThread&); //!< don't call
};

/*! @file
 * @brief 
 * @author Ethan Tira-Thompson (ejt) (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_4_1 $
 * $Revision: 1.2 $
 * $State: Exp $
 * $Date: 2005/06/01 05:48:07 $
 */

#endif
