#include "LoadImageThread.h"

extern "C" {
#include <jpeglib.h>
}
#include "sim.h"
#include "SimConfig.h"

using namespace std;

LoadImageThread::LoadImageThread(std::string source, std::string filter, float fps, MessageQueueBase& messages)
: LoadFileThread(source,filter,fps,messages), cinfo(new jpeg_decompress_struct), jerr(new jpeg_error_mgr), frameIndex(0)
{
	cinfo->err = jpeg_std_error(jerr);
	jpeg_create_decompress(cinfo);
}

LoadImageThread::~LoadImageThread() {
	jpeg_destroy_decompress(cinfo);
	delete cinfo;
	delete jerr;
}

bool LoadImageThread::loadFile(const std::string& file, RCRegion*& data) {
	FILE * infile= fopen(file.c_str(), "rb");
	if (infile==NULL) {
		cerr << "Could not open '" << file << "'" << endl;
		return false;
	}
	jpeg_stdio_src(cinfo, infile);
	jpeg_read_header(cinfo, true);
	cinfo->out_color_space=JCS_YCbCr;
	jpeg_calc_output_dimensions(cinfo);
	if(cinfo->output_width==0 || cinfo->output_height==0) {
		cerr << "Empty image '" << file << "'" << endl;
		return false;
	}
	const unsigned int HEADER_SIZE=sizeof(unsigned int)*5;
	unsigned int reqBufSize=sizeof(JSAMPLE)*cinfo->output_width*cinfo->output_height*cinfo->output_components+HEADER_SIZE;
	if(data==NULL)
		data=new RCRegion(reqBufSize);
	else if(data->Size()<reqBufSize) {
		//too small -- free it, we'll make another one the right size
		freeRegion(data);
		data=new RCRegion(reqBufSize);
	}
	reinterpret_cast<unsigned int*>(data->Base())[0]=cinfo->output_width;
	reinterpret_cast<unsigned int*>(data->Base())[1]=cinfo->output_height;
	reinterpret_cast<unsigned int*>(data->Base())[2]=cinfo->output_components;
	reinterpret_cast<unsigned int*>(data->Base())[3]=frameIndex++;
	reinterpret_cast<int*>(data->Base())[4]=*dynamic_cast<plist::Primitive<int>*>(sim::config.findEntry("Vision.Layer"));
	unsigned int row_stride = cinfo->output_width * cinfo->output_components;
	//JSAMPARRAY buffer = (*cinfo.mem->alloc_sarray)((j_common_ptr) &cinfo, JPOOL_IMAGE, row_stride, 1);
	jpeg_start_decompress(cinfo);
	unsigned int remain=cinfo->output_height;
	JSAMPROW rows[remain];
	rows[0]=reinterpret_cast<JSAMPROW>(data->Base()+HEADER_SIZE);
	for(unsigned int i=1; i<remain; i++)
		rows[i]=rows[i-1]+row_stride;
	JSAMPROW* curpos=rows;
	while (remain>0) {
		unsigned int used=jpeg_read_scanlines(cinfo, curpos, remain);
		curpos+=used;
		remain-=used;
	}
	jpeg_finish_decompress(cinfo);
	fclose(infile);
	if(jerr->num_warnings>0) {
		cerr << "Warning: Decompression of '" << file << "' had warnings" << endl;
		jerr->num_warnings=0;
	}
	return true;
}


/*! @file
 * @brief 
 * @author Ethan Tira-Thompson (ejt) (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_4_1 $
 * $Revision: 1.3 $
 * $State: Exp $
 * $Date: 2005/06/13 18:00:04 $
 */
