//-*-c++-*-
#ifndef INCLUDED_ReferenceCounter_h_
#define INCLUDED_ReferenceCounter_h_

#include <iostream>

//class ReferenceCounter;
//const char* findname(ReferenceCounter* x); // !< tests if @a x is a behavior and outputs its name, otherwise outputs its address

//! Performs simple reference counting, will delete the object when removing the last reference
class ReferenceCounter {
 public:
	//! constructor
	ReferenceCounter() : references(0),RC_autodelete(true) {}
	//! copy constructor - uses autodelete setting of @a rc, but references will still start at 0
	ReferenceCounter(const ReferenceCounter& rc) : references(0),RC_autodelete(rc.RC_autodelete) {}
	//! assignment operator - does nothing because the reference count shouldn't be copied
	ReferenceCounter& operator=(const ReferenceCounter& /*rc*/) {return *this;}

	//! destructor - will std::cout a warning if still has references
	virtual ~ReferenceCounter() {
		if(references>0)
			std::cout << "*** WARNING RefCounter was deleted with " << references << " references" << std::endl;
	}

	//! adds one to #references
	virtual void AddReference() { references++; }
	//! subtracts one from #references AND DELETES the object IF ZERO
	virtual void RemoveReference() {
		if(--references==0) {
			if(RC_autodelete)
				delete this;
		} else if(references==(unsigned int)-1)
			std::cout << "*** WARNING RefCounter went negative" << std::endl;
	}
	//! returns the number of references
	/*! @return references */
	virtual unsigned int GetReferences() const { return references; }

	//! if true, next time a RemoveReference() causes #references to hit 0, the object will delete itself
	void SetAutoDelete(bool b) {RC_autodelete=b;}

	bool GetAutoDelete() { return RC_autodelete; } //!< returns RC_autodelete
	
 protected:
	//! the current number of references
	unsigned int references;

	//! if false, prevents deletion when counter hits 0
	bool RC_autodelete;
};

/*
#include "Behaviors/BehaviorBase.h"

const char* findname(ReferenceCounter* x) {
	BehaviorBase* beh=dynamic_cast<BehaviorBase*>(x);
	if(beh==NULL) {
		static char s[100];
		sprintf(s,"Uknown @ %x",x);
		return s;
	} else {
		static char s2[100];
		sprintf(s2," @ %x",x);
		return (beh->getName()+s2).c_str();
	}
}

*/

/*! @file
 * @brief Defines the ReferenceCounter base class, which allows for automatic memory deallocation
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_4_1 $
 * $Revision: 1.8 $
 * $State: Exp $
 * $Date: 2005/02/02 18:22:29 $
 */

#endif

