#include "ProjectInterface.h"
#include "Wireless/Socket.h"
#include <exception>

namespace ProjectInterface {

	bool displayException(const char * file, int line, const char * message, const std::exception* ex) {
		if(file!=NULL) {
			serr->printf("Exception caught at %s:%d => ",file,line);
		} else {
			serr->printf("Exception => ");
		}
		if(ex!=NULL) {
			serr->printf("'%s'",ex->what());
		} else {
			serr->printf("'%s'","Unknown type");
		}
		if(message!=NULL) {
			serr->printf(" (%s)\n",message);
		} else {
			serr->printf("\n");
		}
		return true;
	}
	bool (*uncaughtException)(const char * file, int line, const char * message, const std::exception* ex)=&displayException;


	FilterBankGenerator * defRawCameraGenerator=0;
	FilterBankGenerator * defInterleavedYUVGenerator=0;
	JPEGGenerator * defColorJPEGGenerator=0;
	JPEGGenerator * defGrayscaleJPEGGenerator=0;
	SegmentedColorGenerator * defSegmentedColorGenerator=0;
	RLEGenerator * defRLEGenerator=0;
	RegionGenerator * defRegionGenerator=0;

	unsigned int visRawCameraSID=0;

	unsigned int visInterleaveSID=0;

	unsigned int visColorJPEGSID=0;
	unsigned int visGrayscaleJPEGSID=1;

	unsigned int visSegmentSID=0;

	unsigned int visRLESID=0;

	unsigned int visRegionSID=0;

	unsigned int visPinkBallSID=0;
	unsigned int visBlueBallSID=1;
	unsigned int visHandSID=2;

	unsigned int doubleLayer=5;
	unsigned int fullLayer=4;
	unsigned int halfLayer=3;
	unsigned int quarterLayer=2;
	unsigned int eighthLayer=1;
	unsigned int sixteenthLayer=0;

}

/*! @file
 * @brief Provides instantiation of the non-required members of ProjectInterface
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_4_1 $
 * $Revision: 1.7 $
 * $State: Exp $
 * $Date: 2005/08/16 18:00:17 $
 */

