//-*-c++-*-
#ifndef INCLUDED_SemaphoreManager_h_
#define INCLUDED_SemaphoreManager_h_

#ifdef PLATFORM_APERIOS
#  warning SemaphoreManager is not Aperios compatable, this is not going to compile
#else

#include "ListMemBuf.h"
#include <sys/types.h>
#include <sys/sem.h>

#ifndef SYSTEM_MAX_SEM
#define SYSTEM_MAX_SEM 250
#endif

//! initializes, manages, and releases a set of System V style semaphores
/*! Should be initialized pre-fork into a shared region */
class SemaphoreManager {
protected:
	static const unsigned int MAX_SEM=SYSTEM_MAX_SEM; //!wouldn't want to claim the entire system's worth, even if we could
	typedef ListMemBuf<bool,MAX_SEM> sems_t;
	sems_t sems;
	
public:
	typedef sems_t::index_t semid_t;
	
	SemaphoreManager();
	SemaphoreManager(const SemaphoreManager& mm);
	SemaphoreManager& operator=(const SemaphoreManager& mm);
	~SemaphoreManager();
	
	void aboutToFork();
	void faultShutdown();
	bool hadFault() const { return semid==-1; }

	semid_t getSemaphore();
	void releaseSemaphore(semid_t id);

	bool lower(semid_t id, unsigned int x, bool block=true) const;
	void raise(semid_t id, unsigned int x) const;
	int getValue(semid_t id) const;
	void setValue(semid_t id, int x) const;
	bool testZero(semid_t id, bool block=true) const;
	bool testZero_add(semid_t id, unsigned int x, bool testblock=true, bool addblock=true) const;
	bool add_testZero(semid_t id, unsigned int x, bool addblock=true, bool testblock=true) const;
	
	unsigned int available() const { return sems_t::MAX_ENTRIES-sems.size(); }
	unsigned int used() const { return sems.size()-(sems_t::MAX_ENTRIES-nsem); }
	semid_t invalid() const { return sems.end(); }

protected:
	unsigned int nsem;
	int semid;
	semid_t mysem;
	semid_t refc;
};

/*! @file
 * @brief Defines SemaphoreManager, which initializes, manages, and releases a set of System V style semaphores
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_4_1 $
 * $Revision: 1.5 $
 * $State: Exp $
 * $Date: 2005/06/15 03:40:05 $
 */

#endif //Aperios check

#endif //INCLUDED

