//-*-c++-*-
#ifndef INCLUDED_ProcessID_h_
#define INCLUDED_ProcessID_h_

//! this is a class instead of a namespace so i can limit write access of the ID value to the OObjects
/*!
 * Although the ProcessID_t enum specifies the maximum number of processes
 * in its NumProcesses value, this doesn't have to correspond to the actual
 * number of active processes.  If you want an element of dynamicism to launch
 * and/or close processes at runtime, simply increase the NumProcesses to a 
 * higher value so that space can be allocated for those processes in shared 
 * memory regions for things like attachment pointers or other per-process
 * data.
 *
 * Not all processes *need* to have a named id, they just need a unique id.
 */
class ProcessID {
public:
	//! Holds ID number for each process
	enum ProcessID_t {
		MainProcess,   //!< MainObj process
		MotionProcess, //!< MotoObj process
		SoundProcess,  //!< SoundPlay process
#ifndef PLATFORM_APERIOS
		SimulatorProcess, //!< for interaction with OS and managing global environment
#endif
		NumProcesses   //!< maximum number of 'friendly' processes -- see class docs
	};
	
	static ProcessID_t getID() { return ID; }  //!< returns process's ID number, or if within a virtual function on a shared object, the process which created it (annoying)
	static void setID(ProcessID_t id) { ID=id; } //!< sets the ID during init (be careful you know what you're doing if you call this)
	
private:
	static ProcessID_t ID; //!< holds ID number
};

/*! @file
 * @brief Defines ProcessID - simple little global for checking which process is currently running, kind of. (see ProcessID::getID() )
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_4_1 $
 * $Revision: 1.2 $
 * $State: Exp $
 * $Date: 2005/06/01 05:47:46 $
 */

#endif
