#ifndef PLATFORM_APERIOS

#include "MessageReceiver.h"
//#include "local/sim/Process.h"
//#include <iostream>
//using namespace std;

MessageReceiver::MessageReceiver(MessageQueueBase& mq, bool (*callback) (RCRegion*)/*=NULL*/, bool startThread/*=true*/)
: Thread(), queue(mq), nextMessage(0), lastProcessedMessage(-1U), process(callback), sleeptime(1000), curit((index_t)-1)
{
	queue.addReceiver();
	if(startThread)
		start();
}

MessageReceiver::~MessageReceiver() {
	if(isRunning())
		queue.removeReceiver();
}

RCRegion * MessageReceiver::peekNextMessage() {
	MessageQueueBase::AutoLock autolock(queue.getLock());
	if(queue.isEnd(curit)) {
		index_t it=queue.newest(); //start with the newest
		while(!queue.isEnd(it) && queue.getMessageSN(it)>=nextMessage)
			it=queue.older(it); //scan back to the first already read by this process
		curit=it=queue.newer(it); //go to the following one (first unread)
	}
	if(queue.isEnd(curit))
		return NULL;
	return queue.peekMessage(curit);
}

RCRegion * MessageReceiver::getNextMessage() {
	MessageQueueBase::AutoLock autolock(queue.getLock());
	index_t it; //will be set to the current message to return; curit will be set to the following message
	if(queue.isEnd(curit)) {
		it=queue.newest(); //start with the newest
		while(!queue.isEnd(it) && queue.getMessageSN(it)>=nextMessage)
			it=queue.older(it); //scan back to the first already read by this process
		curit=it=queue.newer(it); //go to the following one (first unread)
	} else {
		it=curit;
		while(!queue.isEnd(it) && queue.getMessageSN(it)<nextMessage)
			it=queue.newer(it); //scan forward to next message not read by this process
		curit=it;
	}
	if(queue.isEnd(it))
		return NULL;
	nextMessage=queue.getMessageSN(it)+1;
	curit=queue.newer(it); //next time, start on (or peek at) the one after this
	return queue.readMessage(it);
}

void MessageReceiver::markRead() {
	if(queue.isEnd(curit))
		return;
	nextMessage=queue.getMessageSN(curit)+1;
	queue.markRead(curit);
	curit=queue.newer(curit); //next time, start on (or peek at) the one after this
}

void MessageReceiver::waitNextMessage() {
	for(;;) {
		RCRegion * ans=peekNextMessage();
		if(ans!=NULL)
			return;
		usleep(sleeptime);
	}
}

unsigned int MessageReceiver::runloop() {
	RCRegion * msg;
	//cout << Process::getName() << " runloop" << endl;
	while((msg=peekNextMessage())!=NULL) {
		//cout << Process::getName() << " got " << msg->ID().key << ' ' << lastProcessedMessage << ' ' << queue.getMessageSN(curit) << ' ' << curit << endl;
		bool used=false;
		if(lastProcessedMessage!=queue.getMessageSN(curit)) {
			//cout << Process::getName() << " process" << endl;
			lastProcessedMessage=queue.getMessageSN(curit);
			used=process(msg);
			if(used)
				markRead(); // message was consumed, mark it read so next peek will get the next
			//cout << used << ' ' << curit;
			//if(!queue.isEnd(curit))
			//cout << lastProcessedMessage << ' ' << queue.getMessageSN(curit);
			//cout << endl;
		}
		msg->RemoveReference();
		if(!used) //have to break out of the loop to sleep & check interrupts -- otherwise we'll busyloop peeking at the same message
			break;
	}
	return sleeptime;
}

void MessageReceiver::finish() {
	if(!isRunning())
		return;
	stop();
	join();
	RCRegion * msg;
	//cout << Process::getName() << " finish" << endl;
	while((msg=peekNextMessage())!=NULL) {
		//cout << Process::getName() << " got " << msg->ID().key << ' ' << lastProcessedMessage << ' ' << queue.getMessageSN(curit) << ' ' << curit << endl;
		bool used=false;
		if(lastProcessedMessage!=queue.getMessageSN(curit)) {
			//cout << Process::getName() << " process" << endl;
			lastProcessedMessage=queue.getMessageSN(curit);
			used=process(msg);
			if(used)
				markRead(); // message was consumed, mark it read so next peek will get the next
			//cout << used << ' ' << curit;
			//if(!queue.isEnd(curit))
			//cout << lastProcessedMessage << ' ' << queue.getMessageSN(curit);
			//cout << endl;
		}
		msg->RemoveReference();
		if(!used) // if the consumer can't process immediately, we're not waiting around -- drop the rest
			break;
	}
	queue.removeReceiver();
}


/*! @file
 * @brief 
 * @author Ethan Tira-Thompson (ejt) (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_4_1 $
 * $Revision: 1.7 $
 * $State: Exp $
 * $Date: 2005/07/28 18:22:16 $
 */

#endif //PLATFORM_APERIOS check (aperios doesn't support pthreads...)
