#include "WalkToTargetNode.h"
#include "Motion/HeadPointerMC.h"
#include "Motion/WalkMC.h"
#include "Motion/MMAccessor.h"
#include "Events/VisionObjectEvent.h"
#include "Shared/WorldState.h"
#include "Behaviors/Transitions/TimeOutTrans.h"
#include "Behaviors/Transitions/VisualTargetCloseTrans.h"

void WalkToTargetNode::DoStart() {
	StateNode::DoStart();

	headpointer_id = motman->addPersistentMotion(SharedObject<HeadPointerMC>());
	walker_id = motman->addPersistentMotion(SharedObject<WalkMC>());

	erouter->addListener(this,EventBase::visObjEGID,tracking);
}

void WalkToTargetNode::DoStop() {
	erouter->removeListener(this);

	motman->removeMotion(headpointer_id);
	headpointer_id=MotionManager::invalid_MC_ID;
	motman->removeMotion(walker_id);
	walker_id=MotionManager::invalid_MC_ID;

	StateNode::DoStop();
}

//this could be cleaned up event-wise (only use a timer when out of view)
void WalkToTargetNode::processEvent(const EventBase& event) {
	static float horiz=0,vert=0;
	const VisionObjectEvent *ve = dynamic_cast<const VisionObjectEvent*>(&event);
	if(ve!=NULL && event.getTypeID()==EventBase::statusETID) {
		horiz=ve->getCenterX();
		vert=ve->getCenterY();
	} else
		return;

	//cout << "Pos: " << horiz << ' ' << vert << endl;

	double tilt=state->outputs[HeadOffset+TiltOffset]-vert*M_PI/6;
	double pan=state->outputs[HeadOffset+PanOffset]-horiz*M_PI/7.5;
	if(tilt>outputRanges[HeadOffset+TiltOffset][MaxRange])
		tilt=outputRanges[HeadOffset+TiltOffset][MaxRange];
	if(tilt<outputRanges[HeadOffset+TiltOffset][MinRange]*3/4)
		tilt=outputRanges[HeadOffset+TiltOffset][MinRange]*3/4;
	if(pan>outputRanges[HeadOffset+PanOffset][MaxRange]*2/3)
		pan=outputRanges[HeadOffset+PanOffset][MaxRange]*2/3;
	if(pan<outputRanges[HeadOffset+PanOffset][MinRange]*2/3)
		pan=outputRanges[HeadOffset+PanOffset][MinRange]*2/3;
	{MMAccessor<HeadPointerMC>(headpointer_id)->setJoints(tilt,pan,0);} //note use of {}'s to limit scope
	
	{
		MMAccessor<WalkMC> walker(walker_id);
		if(pan<-.05 || pan>.05)
			walker->setTargetVelocity(100,0,pan);
		else
			walker->setTargetVelocity(160,0,0);
	}
}

Transition* WalkToTargetNode::newDefaultLostTrans(StateNode* dest) {
	return new TimeOutTrans(dest,1500,EventBase::visObjEGID,tracking);
}

Transition* WalkToTargetNode::newDefaultCloseTrans(StateNode* dest) {
	return new VisualTargetCloseTrans(dest,tracking);
}


/*! @file
 * @brief Implements WalkToTargetNode, a state node for walking towards a visual target
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_4_1 $
 * $Revision: 1.1 $
 * $State: Exp $
 * $Date: 2004/12/05 04:47:53 $
 */

