//-*-c++-*-
#ifndef INCLUDED_TailWagNode_h_
#define INCLUDED_TailWagNode_h_

#include "Behaviors/StateNode.h"
#include "Events/EventRouter.h"
#include "Motion/TailWagMC.h"

//! A simple StateNode that executes a TailWagMC motion command
class TailWagNode : public StateNode {
protected:
  SharedObject<TailWagMC> tail_mc;    //!< MotionCommand used by this node
  MotionManager::MC_ID tail_id;  //!< id number for the MotionCommand

public:
  //! constructor
  TailWagNode(std::string nodename="TailWagNode") : 
    StateNode("TailWagNode",nodename), tail_mc(), tail_id(MotionManager::invalid_MC_ID) {}

  //! activate the node
  virtual void DoStart() {
    StateNode::DoStart();
    tail_id = motman->addPersistentMotion(tail_mc);
    erouter->addListener(this,EventBase::motmanEGID,tail_id,EventBase::statusETID);
  }

  //! deactivate the node
  virtual void DoStop() {
    motman->removeMotion(tail_id);
    tail_id = MotionManager::invalid_MC_ID;
    erouter->removeListener(this);
    StateNode::DoStop();
  }

  //! receive motmanEGID status event and throw stateMachineEGID status event - this doesn't ever actually happen for a TailWagMC, but just for completeness...
  virtual void processEvent(const EventBase&) {
		postCompletionEvent();
  }

  //! reveal the MotionCommand itself, use getMC_ID() instead if this node isActive().
  SharedObject<TailWagMC>& getMC() { return tail_mc; }

  //! reveal the MC_ID
  MotionManager::MC_ID& getMC_ID() { return tail_id; }


};

/*! @file
 * @brief Defines TailWagNode, a simple StateNode that runs a TailWagMC motion command
 * @author dst, ejt (Creators)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_4_1 $
 * $Revision: 1.2 $
 * $State: Exp $
 * $Date: 2005/01/24 22:23:50 $
 */

#endif
