//-*-c++-*-
#ifndef INCLUDED_LedNode_h_
#define INCLUDED_LedNode_h_

#include "Behaviors/StateNode.h"
#include "Events/EventRouter.h"
#include "Motion/LedMC.h"

//! A simple StateNode that executes a LedMC motion command and throws a status event upon completion
class LedNode : public StateNode {
protected:
  SharedObject<LedMC> leds_mc;    //!< MotionCommand used by this node
  MotionManager::MC_ID leds_id;  //!< id number for the MotionCommand

public:
  //! constructor
  LedNode(std::string nodename="LedNode") : 
    StateNode("LedNode",nodename), leds_mc(), leds_id(MotionManager::invalid_MC_ID) {}

  //! activate the node
  virtual void DoStart() {
    leds_id = motman->addPersistentMotion(leds_mc);
    erouter->addListener(this,EventBase::motmanEGID,leds_id,EventBase::statusETID);
    StateNode::DoStart();  // don't activate transitions until our listener has been added
  }

  //! deactivate the node
  virtual void DoStop() {
    motman->removeMotion(leds_id);
    leds_id = MotionManager::invalid_MC_ID;
    erouter->removeListener(this);
    StateNode::DoStop();
  }

  //! receive motmanEGID status event and throw stateMachineEGID status event
  virtual void processEvent(const EventBase&) {
		postCompletionEvent();
  }

  //! reveal the MotionCommand
  SharedObject<LedMC>& getMC() { return leds_mc; }

  //! reveal the MC_ID
  MotionManager::MC_ID& getMC_ID() { return leds_id; }

protected:
  //! constructor
  LedNode(const std::string &classname, const std::string &nodename) : 
    StateNode(classname,nodename), leds_mc(), leds_id(MotionManager::invalid_MC_ID) {}


};

/*! @file
 * @brief Defines LedNode, a simple StateNode that runs a LedMC motion command and throws a status event upon completion
 * @author dst (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_4_1 $
 * $Revision: 1.6 $
 * $State: Exp $
 * $Date: 2005/06/01 05:47:46 $
 */

#endif
