//-*-c++-*-
#ifndef INCLUDED_SimulatorAdvanceFrameControl_h
#define INCLUDED_SimulatorAdvanceFrameControl_h

#include "Behaviors/Controls/NullControl.h"
#ifdef PLATFORM_APERIOS
#  warning SimulatorAdvanceFrameControl is only useful when running in simulation!
#else
#  include "local/sim/Main.h"
#endif

//! Requests the next camera frame and sensor data, for use when running in simulation
/*! There are a number of options regarding control of input data and
 *  flow of time.  This is only applicable when using a non-realtime
 *  source (such as loading logged data from disk) and the simulator's
 *  AdvanceOnAccess is 'false' (this is "advance on request" -- the
 *  same data may be accessed multiple times until you manually
 *  request the next frame) */
class SimulatorAdvanceFrameControl : public NullControl {

public:
	//! default constructor
	SimulatorAdvanceFrameControl()
		: NullControl("SimulatorAdvanceFrameControl","Requests the next camera frame and sensor data, for use when running in simulation")
	{}
	//! constructor which allows a custom name
	SimulatorAdvanceFrameControl(const std::string& n)
		: NullControl(n,"Requests the next camera frame and sensor data, for use when running in simulation")
	{}

	//can't do anything if we're running on aperios
#ifndef PLATFORM_APERIOS

	virtual ControlBase * activate(MotionManager::MC_ID disp_id, Socket * gui) {
		Main::advanceVision();
		Main::advanceSensor();
		return NullControl::activate(disp_id,gui);
	}

	virtual std::string getName() const {
		if(Main::canManuallyAdvance())
			return NullControl::getName();
		return "[Auto-Advancing]";
	}

	virtual std::string getDescription() const {
		if(Main::canManuallyAdvance())
			return NullControl::getDescription();
		return "Cannot manually advance when in realtime mode, or when AdvanceOnAccess is enabled";
	}
	
#endif

};

/*! @file
 * @brief Defines SimulatorAdvanceFrameControl, which requests the next camera frame and sensor data, for use when running in simulation
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_4_1 $
 * $Revision: 1.1 $
 * $State: Exp $
 * $Date: 2005/06/23 22:37:28 $
 */
#endif
