#include "BehaviorBase.h"
#include "Events/EventRouter.h"

std::set<BehaviorBase*> BehaviorBase::registry;

BehaviorBase::BehaviorBase(const std::string& name)
	: ReferenceCounter(), EventListener(), started(false),
	  instanceName(name), className(name)
{
	registry.insert(this);
}

BehaviorBase::BehaviorBase(const std::string& classname, const std::string& instancename)
	: ReferenceCounter(), EventListener(), started(false),
	  instanceName(instancename), className(classname)
{
	registry.insert(this);
}


BehaviorBase::BehaviorBase(const BehaviorBase& b)
	: ReferenceCounter(b), EventListener(b), started(b.started),
	  instanceName(b.instanceName), className(b.className)
{
	registry.insert(this);
}

BehaviorBase&
BehaviorBase::operator=(const BehaviorBase& b) {
	ReferenceCounter::operator=(b);
	EventListener::operator=(b);
	started=b.started;
	instanceName=b.instanceName;
	return *this;
}

BehaviorBase::~BehaviorBase() {
	SetAutoDelete(false);
	if(started)
		std::cerr << "Behavior " << getName() << " deleted while running: use 'RemoveReference', not 'delete'" << std::endl;
	erouter->removeListener(this);
	registry.erase(this);
}

void
BehaviorBase::DoStart() {
	//std::cout << getName() << " started " << this << std::endl;
	if(!started) {
		started=true;
		AddReference();
	}
}

void
BehaviorBase::DoStop() {
	//std::cout << getName() << " stopped " << this << std::endl;
	if(started) {
		started=false;
		erouter->removeListener(this);
		erouter->removeTimer(this);
		RemoveReference();
	}
}

/*! @file
 * @brief Implements BehaviorBase from which all Behaviors should inherit
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_4_1 $
 * $Revision: 1.9 $
 * $State: Exp $
 * $Date: 2005/07/07 22:33:51 $
 */

