#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <iostream>
#include <sys/stat.h>
#include <utime.h>

using namespace std;

int usage(unsigned int argc, const char* argv[]) {
	cerr << "Usage: "<<argv[0]<<" filename ... \n"
			 << "       This will round the modification time of filename up to the\n"
			 << "       nearest even second.\n"
			 << "       \n"
			 << "       This is useful for cleaning up modification times on a PC before\n"
			 << "       synchronizing with a memory stick, since memory sticks apparently\n"
			 << "       do not store odd seconds, which causes confusion for programs\n"
			 << "       such as rsync" << endl;
	return 2;
}


/*	   << "       This will then output the modification time of filename rounded\n"
			 << "       up to the nearest even second in the format YYYYMMDDHHMMSS.\n"
*/

int main(unsigned int argc, const char* argv[]) {
	int status;
	if(argc<2)
		return usage(argc,argv);
	for(unsigned int i=1; i<argc; i++) {
		struct stat stat_buf;
		status=lstat(argv[i],&stat_buf);
		if(status) {
			cerr << argv[0] << ": Bad file '" << argv[i] << "'" << endl;
			return 1;
		}
		stat_buf.st_mtime=(stat_buf.st_mtime+1) & ~1;
		//  struct tm * tm_buf;
		//	tm_buf=localtime(&stat_buf.st_mtime);
		//	char out[1024];
		//	strftime(out,1024,"%Y%m%d%H%M.%S",tm_buf);
		//	cout << out << endl;
		struct utimbuf  ut_buf;
		ut_buf.actime=stat_buf.st_atime;
		ut_buf.modtime=stat_buf.st_mtime;
		status=utime(argv[i],&ut_buf);
		if(status) {
			cerr << argv[0] << ": Bad file '" << argv[i] << "'" << endl;
			return 1;
		}
	}
	return 0;
}
