#include "Socket.h"
#include <stdio.h>
#ifdef PLATFORM_APERIOS
#  include "Wireless.h"
#endif
#include "Shared/Config.h"
#include <unistd.h>

Socket* sout=NULL;
Socket* serr=NULL;

byte*
Socket::getWriteBuffer(int bytesreq)
{
  if (sendBufSize-writeSize>=bytesreq
      && state==CONNECTION_CONNECTED)
    return writeData+writeSize;
  if (state!=CONNECTION_CONNECTED) {
		if(forwardSock!=NULL)
			return forwardSock->getWriteBuffer(bytesreq);
		if(textForward)
			return (byte*)(textForwardBuf=new char[bytesreq]);
  }
	return NULL;
}

void
Socket::write(int size)
{
  writeSize+=size;
	if(textForwardBuf) {
		::write(STDOUT_FILENO,textForwardBuf,size);
		delete textForwardBuf;
		textForwardBuf=NULL;
	} else
		flush();
}

int
Socket::read()
{
  return -1;
}

byte*
Socket::getReadBuffer()
{
	return NULL;
//  return readData+readSize;
}

void
Socket::init()
{
  sendSize=0;
  writeSize=0;
}

int
Socket::setFlushType(FlushType_t fType)
{
  if (state != CONNECTION_CLOSED) return -1;
  flType=fType;
  return 0;
}

void
Socket::flush()
{
  if (state!=CONNECTION_CONNECTED) {
		if(forwardSock!=NULL)
			return forwardSock->flush();
	} else {
		if (flType==FLUSH_NONBLOCKING) {
			if (!tx) {
				byte *tempData=sendData;
				int tempSize=sendSize;
				sendData=writeData;
				writeData=tempData;
				sendSize=writeSize;
				writeSize=tempSize;
#ifdef PLATFORM_APERIOS
				wireless->send(sock);
#endif
			}
		} else {
			sendData=writeData;
			sendSize=writeSize;
#ifdef PLATFORM_APERIOS
			wireless->blockingSend(sock);
#endif
			writeSize=0;
		}
	}
}

int
Socket::pprintf(int vlevel, const char *fmt, ...)
{
  if (vlevel>verbosity) return 0;

  int ret;
  va_list al;
  va_start(al,fmt);
  ret=this->printf(fmt, al); 
  va_end(al);

  return ret;
}

int
Socket::printf(const char *fmt, ...)
{
  va_list al;
  va_start(al,fmt);
	int ret=vprintf(fmt,al);
  va_end(al);
  return ret;
}

int
Socket::vprintf(const char *fmt, va_list al)
{
  if (state==CONNECTION_CONNECTED && (sendBufSize-writeSize<256)) {
    flush();
    if (sendBufSize-writeSize<256)
      return -1;
  }

  if (state!=CONNECTION_CONNECTED) {
		if(forwardSock!=NULL)
			return forwardSock->vprintf(fmt,al);
		if(textForward)
			return vfprintf(stdout, fmt, al);
  } else {
    int ret=vsprintf((char *)(writeData+writeSize), fmt, al);
		writeSize+=ret;
		flush();
		return ret;
  }
	return -1;
}

int
Socket::write(const byte *buf, int size)
{
  if (state!=CONNECTION_CONNECTED) {
		if(forwardSock!=NULL)
			return forwardSock->write(buf,size);
		if(textForward)
			return ::write(STDOUT_FILENO,buf,size);
	} else {
		byte *destbuf=getWriteBuffer(size);
		if (destbuf==NULL) return -1;
		memcpy(destbuf, buf, size);
		write(size);
		return size;
	}
	return -1;
}

int
Socket::read(byte * /*buf*/, int /*size*/)
{  
/*  if (size>=recvBufSize-recvPos) return -1;
  memcpy(buf,recvData+recvPos,size);*/
  return -1;
}

/*! @file
 * @brief Implements Tekkotsu wireless Socket class, also sout and serr
 * @author alokl (Creator)
 * 
 * $Author: ejt $
 * $Name: tekkotsu-2_3 $
 * $Revision: 1.17 $
 * $State: Exp $
 * $Date: 2004/10/04 20:38:05 $
 */

