#include "RLEGenerator.h"
#include "Events/EventRouter.h"
#include "Events/SegmentedColorFilterBankEvent.h"
#include "Wireless/Wireless.h"
#include "Shared/WorldState.h"

#include "Shared/debuget.h"

RLEGenerator::RLEGenerator(EventBase::EventGeneratorID_t gid, unsigned int sid, unsigned int mysid)
	: FilterBankGenerator("RLEGenerator",gid,sid,EventBase::visRLEEGID,mysid), numRuns(NULL), maxRuns(NULL)
{ }

void
RLEGenerator::processEvent(const EventBase& event) {
	FilterBankGenerator::processEvent(event);
	if(event.getGeneratorID()==getListenGeneratorID() && event.getSourceID()==getListenSourceID()) {
		if(const SegmentedColorFilterBankEvent * segsrc=dynamic_cast<const SegmentedColorFilterBankEvent *>(&event))
			erouter->postEvent(new SegmentedColorFilterBankEvent(this,getGeneratorID(),getSourceID(),*segsrc));
		else
			erouter->postEvent(new FilterBankEvent(this,getGeneratorID(),getSourceID()));
	}
}

unsigned int
RLEGenerator::getBinSize() const {
	unsigned int used=FilterBankGenerator::getBinSize();
	used+=strlen("RLEImage")+LoadSave::stringpad;
	used+=sizeof(unsigned int);
	if(imageValids[selectedSaveLayer][selectedSaveChannel])
		used+=XMIT_BYTES_PER_RUN*numRuns[selectedSaveLayer][selectedSaveChannel];
	else
		used+=XMIT_BYTES_PER_RUN*maxRuns[selectedSaveLayer];
	return used;
}

/*! this isn't really tested, don't rely on it working without a little debugging... specifically, doesn't set parent or next fields*/
unsigned int
RLEGenerator::LoadBuffer(const char buf[], unsigned int len) {
	unsigned int origlen=len;
	unsigned int used;
	std::string tmp;
	if(0==(used=FilterBankGenerator::LoadBuffer(buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=decode(tmp,buf,len))) return 0;
	len-=used; buf+=used;
	if(tmp!="RLEImage") {
		serr->printf("Unhandled image type for RLEGenerator: %s",tmp.c_str());
		return 0;
	} else {
		if(0==(used=decode(numRuns[selectedSaveLayer][selectedSaveChannel],buf,len))) return 0;
		len-=used; buf+=used;
		if(maxRuns[selectedSaveLayer]<numRuns[selectedSaveLayer][selectedSaveChannel])
			return 0;
		if(images[selectedSaveLayer][selectedSaveChannel]==NULL)
			images[selectedSaveLayer][selectedSaveChannel]=createImageCache(selectedSaveLayer,selectedSaveChannel);
		run * runs=reinterpret_cast<run*>(images[selectedSaveLayer][selectedSaveChannel]);
		if(runs==NULL)
			return 0;
		unsigned int y=0;
		for(unsigned int i=0; i<numRuns[selectedSaveLayer][selectedSaveChannel]; i++) {
			if(0==(used=decode(runs[i].color,buf,len))) return 0;
			len-=used; buf+=used;
			if(0==(used=decode(runs[i].x,buf,len))) return 0;
			len-=used; buf+=used;
			if(0==(used=decode(runs[i].width,buf,len))) return 0;
			len-=used; buf+=used;
			if((unsigned int)(runs[i].x+runs[i].width)>=getWidth(selectedSaveLayer))
				y++;
			runs[i].y=y;
		}
		imageValids[selectedSaveLayer][selectedSaveChannel]=true;
		return origlen-len;	
	}
}

unsigned int
RLEGenerator::SaveBuffer(char buf[], unsigned int len) const {
	unsigned int origlen=len;
	unsigned int used;
	if(0==(used=FilterBankGenerator::SaveBuffer(buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=encode("RLEImage",buf,len))) return 0;
	len-=used; buf+=used;
	
	run * runs=reinterpret_cast<run*>(getImage(selectedSaveLayer,selectedSaveChannel));
	if(runs==NULL)
		return 0;
	if(0==(used=encode(numRuns[selectedSaveLayer][selectedSaveChannel],buf,len))) return 0;
	len-=used; buf+=used;
	for(unsigned int i=0; i<numRuns[selectedSaveLayer][selectedSaveChannel]; i++) {
		if(0==(used=encode(runs[i].color,buf,len))) return 0;
		len-=used; buf+=used;
		if(0==(used=encode(runs[i].x,buf,len))) return 0;
		len-=used; buf+=used;
		if(0==(used=encode(runs[i].width,buf,len))) return 0;
		len-=used; buf+=used;
	}
	return origlen-len;
}

void
RLEGenerator::setDimensions() {
	FilterBankGenerator::setDimensions();
	for(unsigned int i=0; i<numLayers; i++)
		maxRuns[i]=calcExpMaxRuns(i);
}

void
RLEGenerator::setNumImages(unsigned int nLayers, unsigned int nChannels) {
	if(nLayers==numLayers && nChannels==numChannels)
		return;
	FilterBankGenerator::setNumImages(nLayers,nChannels); //calls destruct()...
	maxRuns=new unsigned int[numLayers];
	numRuns=new unsigned int*[numLayers];
	for(unsigned int i=0; i<numLayers; i++) {
		maxRuns[i]=calcExpMaxRuns(i);
		numRuns[i]=new unsigned int[numChannels];
	}
}

//! simply creates a new data region and returns it
unsigned char *
RLEGenerator::createImageCache(unsigned int layer, unsigned int /*chan*/) const {
	return reinterpret_cast<unsigned char*>(new run[maxRuns[layer]]);
}

//! a single call to the CMVision library to do the work, and we're done.
void
RLEGenerator::calcImage(unsigned int layer, unsigned int chan) const {
	PROFSECTION("RLEGenerator::calcImage(...)",state->mainProfile);
  numRuns[layer][chan] = CMVision::EncodeRuns(reinterpret_cast<run*>(images[layer][chan]),src->getImage(layer,chan),getWidth(layer),getHeight(layer),maxRuns[layer]);
	imageValids[layer][chan]=true; // <--- don't forget to do this, otherwise you'll recompute on every access, even if the cache is still valid
}

void
RLEGenerator::destruct() {
	FilterBankGenerator::destruct();
	for(unsigned int i=0; i<numLayers; i++)
		delete [] numRuns[i];
	delete [] numRuns;
	numRuns=NULL;
	delete [] maxRuns;
	maxRuns=NULL;
}

/*! @file
 * @brief Implements RLEGenerator, which generates RLE compressed FilterBankEvents (generally from indexed color images from, say, SegmentedColorGenerator)
 * @author alokl (Creator)
 * @author ejt (reorganized)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_3 $
 * $Revision: 1.8 $
 * $State: Exp $
 * $Date: 2004/11/09 20:01:49 $
 */

