#include "string_util.h"
#include <ctype.h>

namespace string_util {

	std::string makeLower(const std::string& s) {
		std::string ans(s.size(),'#');
		unsigned int i=s.size();
		while(i--!=0)
			ans[i]=::tolower(s[i]);
		return ans;
	}

	std::string makeUpper(const std::string& s) {
		std::string ans(s.size(),'#');
		unsigned int i=s.size();
		while(i--!=0)
			ans[i]=::toupper(s[i]);
		return ans;
	}

	std::string removePrefix(const std::string& str, const std::string& pre) {
		if(str.compare(0,pre.size(),pre)==0)
			return str.substr(pre.size());
		return std::string();
	}

	bool parseArgs(const std::string& input, std::vector<std::string>& args, std::vector<unsigned int>& offsets) {
		std::string cur;
		bool isDoubleQuote=false;
		bool isSingleQuote=false;
		args.clear();
		offsets.clear();
		unsigned int begin=-1U;
		for(unsigned int i=0; i<input.size(); i++) {
			char c=input[i];
			if(begin==-1U && !isspace(c))
				begin=i;
			switch(c) {
			case ' ':
			case '\n':
			case '\r':
			case '\t':
			case '\v':
			case '\f':
				if(isSingleQuote || isDoubleQuote)
					cur+=c;
				else if(cur.size()!=0) {
					args.push_back(cur);
					offsets.push_back(begin);
					cur.clear();
					begin=-1U;
				}
				break;
			case '\\':
				if(i==input.size()-1) { //escaped line break
					return false;
				} else
					cur.push_back(input[++i]);
				break;
			case '"':
				if(isSingleQuote)
					cur.push_back(c);
				else
					isDoubleQuote=!isDoubleQuote;
				break;
			case '\'':
				if(isDoubleQuote)
					cur+=c;
				else
					isSingleQuote=!isSingleQuote;
				break;
			default:
				cur+=c;
				break;
			}
		}
		if(cur.size()>0) {
			args.push_back(cur);
			offsets.push_back(begin);
		}
		return !isDoubleQuote && !isSingleQuote;
	}

}

/*! @file
 * @brief Implements some useful functions for string manipulation in the string_util namespace
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_3 $
 * $Revision: 1.3 $
 * $State: Exp $
 * $Date: 2004/01/14 20:45:28 $
 */
