//-*-c++-*-
/*=========================================================================
    CMPack'02 Source Code Release for OPEN-R SDK v1.0
    Copyright (C) 2002 Multirobot Lab [Project Head: Manuela Veloso]
    School of Computer Science, Carnegie Mellon University
  -------------------------------------------------------------------------
    This software is distributed under the GNU General Public License,
    version 2.  If you do not have a copy of this licence, visit
    www.gnu.org, or write: Free Software Foundation, 59 Temple Place,
    Suite 330 Boston, MA 02111-1307 USA.  This program is distributed
    in the hope that it will be useful, but WITHOUT ANY WARRANTY,
    including MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  -------------------------------------------------------------------------
    Additionally licensed to Sony Corporation under the following terms:

    This software is provided by the copyright holders AS IS and any
    express or implied warranties, including, but not limited to, the
    implied warranties of merchantability and fitness for a particular
    purpose are disclaimed.  In no event shall authors be liable for
    any direct, indirect, incidental, special, exemplary, or consequential
    damages (including, but not limited to, procurement of substitute
    goods or services; loss of use, data, or profits; or business
    interruption) however caused and on any theory of liability, whether
    in contract, strict liability, or tort (including negligence or
    otherwise) arising in any way out of the use of this software, even if
    advised of the possibility of such damage.
  =========================================================================
*/
#ifndef INCLUDED_SystemUtility_h
#define INCLUDED_SystemUtility_h

#include <MCOOP.h>

#ifdef PLATFORM_APERIOS
//! Gets memory from Aperios/OPEN-R using system's NewRegion command
/*! This seems to be the thing to do when getting large regions?  We've
 *  had some issues with large regions returned from @c new which overlap.
 *  This issue may no longer exist, was never well known. */
template <class T>
T *NewLarge(T **dst, int count) {
  sError result;
  result=NewRegion(sizeof(T)*count+8096, reinterpret_cast<void **>(dst));
  if (result != sSUCCESS)
    *dst=NULL;

  return *dst;
}

//! Frees memory from Aperios/OPEN-R using system's DeleteRegion command (use only on regions obtained from NewLarge)
template <class T>
void DeleteLarge(T *dst) {
  DeleteRegion(dst);
}
#endif

/*! @file
 * @brief Wrappers for getting large memory regions from Aperios
 * @author CMU RoboSoccer 2001-2002 (Creator)
 * 
 * @verbinclude CMPack_license.txt
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_3 $
 * $Revision: 1.4 $
 * $State: Rel $
 * $Date: 2003/10/10 17:46:04 $
 */

#endif
