#include "VisionObjectEvent.h"
#include <sstream>

// Changed 'getDescription' to show BB and area info in EventLogger. Change functions to add new parameters (BB and area) to buffer

std::string
VisionObjectEvent::getDescription(bool showTypeSpecific/*=true*/, unsigned int verbosity/*=0*/) const {
	if(!showTypeSpecific)
		return EventBase::getDescription(showTypeSpecific,verbosity);
	std::ostringstream logdata;
	logdata << EventBase::getDescription(showTypeSpecific,verbosity) << '\t' << _x1 <<  '\t' <<_x2 <<'\t' <<_y1 <<'\t' <<_y2 ;
	return logdata.str();
}

unsigned int
VisionObjectEvent::getBinSize() const {
	unsigned int used=EventBase::getBinSize();
	used+=creatorSize("EventBase::VisionObjectEvent");
	used+=sizeof(_x1);
	used+=sizeof(_x2);
	used+=sizeof(_y1);
	used+=sizeof(_y2);
	return used;
}

unsigned int
VisionObjectEvent::LoadBuffer(const char buf[], unsigned int len) {
	unsigned int origlen=len;
	unsigned int used;
	if(0==(used=EventBase::LoadBuffer(buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=checkCreator("EventBase::VisionObjectEvent",buf,len,true))) return 0;
	len-=used; buf+=used;
	if(0==(used=decode(_x1,buf,len))) return 0;
	len-=used; buf+=used;	
	if(0==(used=decode(_x2,buf,len))) return 0;
	len-=used; buf+=used;	
	if(0==(used=decode(_y1,buf,len))) return 0;
	len-=used; buf+=used;	
	if(0==(used=decode(_y2,buf,len))) return 0;
	len-=used; buf+=used;	
	return origlen-len;	
}

unsigned int
VisionObjectEvent::SaveBuffer(char buf[], unsigned int len) const {
	unsigned int origlen=len;
	unsigned int used;
	if(0==(used=EventBase::SaveBuffer(buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=saveCreator("EventBase::VisionObjectEvent",buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=encode(_x1,buf,len))) return 0;
	len-=used; buf+=used;	
	if(0==(used=encode(_x2,buf,len))) return 0;
	len-=used; buf+=used;	
	if(0==(used=encode(_y1,buf,len))) return 0;
	len-=used; buf+=used;	
	if(0==(used=encode(_y2,buf,len))) return 0;
	len-=used; buf+=used;	
	return origlen-len;
}

/*! @file
 * @brief Implements VisionObjectEvent, which provides information about objects recognized in the camera image
 * @author alokl (Creator)
 * @author Ignacio Herrero Reder <nhr at dte uma es> (VisionObjectInfo Boundary Box - bug 74)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_3 $
 * $Revision: 1.5 $
 * $State: Exp $
 * $Date: 2005/01/12 21:48:17 $
 */
