#include "EventTranslator.h"
#include "Events/LocomotionEvent.h"
#include "Events/VisionObjectEvent.h"
#include "Events/TextMsgEvent.h"
#include "Events/EventRouter.h"
#include "Shared/debuget.h"
#include <iostream>

bool
EventTranslator::trapEvent(const EventBase& event) {
	enqueue(event,queue);
	return true;
}

void
EventTranslator::enqueue(const EventBase& event, Queue_t * q) {
	unsigned int len=event.getBinSize();
	TypeID_t type;
	if(dynamic_cast<const LocomotionEvent*>(&event)!=NULL) {
		type=LocomotionEvent_ID;
	} else if(dynamic_cast<const VisionObjectEvent*>(&event)!=NULL) {
		type=VisionObjectEvent_ID;
	} else if(dynamic_cast<const TextMsgEvent*>(&event)!=NULL) {
		type=TextMsgEvent_ID;
	} else {
		ASSERT(dynamic_cast<const EventBase*>(&event)!=NULL,"stupid OS/compiler/linker/whatever");
		type=EventBase_ID;
	}
	void* buf=q->reserve(sizeof(TypeID_t)+len);
	if(buf==NULL) {
		ASSERT(false,"Queue overflow "<<type<<' '<<len);
	} else {
		*reinterpret_cast<TypeID_t*>(buf)=type;
		reinterpret_cast<char*>(buf)+=sizeof(TypeID_t);
		unsigned int err=event.SaveBuffer(reinterpret_cast<char*>(buf),len);
		ASSERT(err!=0,"bad save");
	}
	q->done();
}
	
void
EventTranslator::translateEvents() {
	unsigned int i;
	for(i=0; i<queue->size(); i++)
		sendEvent(queue->data(i),queue->size(i));
	while(!queue->clear(i)) //needed so if another was added while we were processing last one we will get it
		sendEvent(queue->data(i++),queue->size(i));
}

void
EventTranslator::sendEvent(const void * entry, unsigned int size) {
	TypeID_t type=*reinterpret_cast<const TypeID_t*>(entry);
	const char* buf=reinterpret_cast<const char*>(entry)+sizeof(TypeID_t);
	size-=sizeof(TypeID_t);
	EventBase * evt=NULL;
	switch(type) {
	case LocomotionEvent_ID: {
		evt=new LocomotionEvent;
	} break;
	case VisionObjectEvent_ID: {
		evt=new VisionObjectEvent;
	} break;
	case TextMsgEvent_ID: {
		evt=new TextMsgEvent;
	} break;
	case EventBase_ID: {
		evt=new EventBase;
	} break;
	//no default case because we want
	//a compiler warning if we miss one
	}
	ASSERTRET(evt!=NULL,"Unrecognized entry type");
	unsigned int err=evt->LoadBuffer(buf,size);
	if(err==0) {
		std::cout<<"ERROR: type="<<type<< " len="<<size<<std::endl;
		for(unsigned int i=0; i<size; i++) {
			printf("%hx",buf[i]);
			if(i%10==0)
				printf("\n");
			else if(i%4==0)
				printf(" ");
		}
		std::cout << "This is a rare bug we are trying to track down.\n"
			"Please email a brief message containing the above\n"
			"hex dump to info@tekkotsu.org.  Thank you!" << std::endl;
	}
	ASSERTRET(err!=0,"bad load");
	ASSERTRET(evt->getGeneratorID()<EventBase::numEGIDs && evt->getTypeID()<EventBase::numETIDs,
						"invalid EGID "<<evt->getGeneratorID()<<" or ETID "<<evt->getTypeID());
	erouter->postEvent(evt);
}


/*! @file
 * @brief Implements EventTranslator, which receives events from EventRouters in non-Main processes and adds them into a SharedQueue for Main to pick up
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_3 $
 * $Revision: 1.8 $
 * $State: Exp $
 * $Date: 2005/01/29 00:02:55 $
 */

