#include "EventGeneratorBase.h"
#include "Events/EventRouter.h"

using namespace std;

void
EventGeneratorBase::DoStart() {
	BehaviorBase::DoStart();
	if(autoListen) {
		erouter->addListener(this,EventBase::erouterEGID,getGeneratorID());
		if(erouter->hasListeners(getGeneratorID(),getSourceID())) {
			erouter->addListener(this,getListenGeneratorID(),getListenSourceID());
			isListening=true;
		}
	}
}

void
EventGeneratorBase::DoStop() {
	erouter->removeListener(this);
	isListening=false;
	BehaviorBase::DoStop();
}

void
EventGeneratorBase::processEvent(const EventBase& event) {
	if(!autoListen)
		return;
	if(event.getGeneratorID()==EventBase::erouterEGID) {
		if(erouter->hasListeners(getGeneratorID(),getSourceID())) {
			if(!isListening) {
				erouter->addListener(this,getListenGeneratorID(),getListenSourceID());
				isListening=true;
			}
		} else {
			if(isListening) {
				erouter->removeListener(this,getListenGeneratorID(),getListenSourceID());
				isListening=false;
			}
		}
	}
}

void
EventGeneratorBase::setAutoListen(EventBase::EventGeneratorID_t gid, unsigned int sid) {
	if(isListening) {
		erouter->removeListener(this,getListenGeneratorID(),getListenSourceID());
		isListening=false;
	}
	autoListen=true;
	srcGenID=gid;
	srcSourceID=sid;
		if(erouter->hasListeners(getGeneratorID(),getSourceID())) {
		if(!isListening) {
			erouter->addListener(this,getListenGeneratorID(),getListenSourceID());
			isListening=true;
		}
	}
}

void
EventGeneratorBase::unsetAutoListen() {
	if(isListening) {
		erouter->removeListener(this,getListenGeneratorID(),getListenSourceID());
		isListening=false;
	}
	autoListen=false;
}


/*! @file
 * @brief 
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_3 $
 * $Revision: 1.3 $
 * $State: Exp $
 * $Date: 2004/11/09 20:01:49 $
 */

