#include "WallTestBehavior.h"
#include "Shared/newmat/newmat.h"
#include "Shared/newmat/newmatap.h"
#include "Events/EventRouter.h"
#include "Motion/MotionManager.h"
#include "Motion/MotionSequenceMC.h"
#include "Shared/Config.h"
#include "Shared/WorldState.h"
#include "Shared/newmat/newmatio.h"
#include <fstream>

void
WallTestBehavior::DoStart() {
	BehaviorBase::DoStart(); // do this first
	int startrec,stoprec;
	SharedObject<SmallMotionSequenceMC> pan;
	pan->setTime(startrec=reposTime);
	pan->setPose(PostureEngine(config->motion.makePath("stand.pos").c_str()));
	pan->setOutputCmd(HeadOffset+TiltOffset,0);
	pan->setOutputCmd(HeadOffset+PanOffset,outputRanges[HeadOffset+PanOffset][MaxRange]);
	pan->setOutputCmd(HeadOffset+RollOffset,0);
	stoprec=pan->advanceTime(panTime);
	pan->setOutputCmd(HeadOffset+TiltOffset,0);
	pan->setOutputCmd(HeadOffset+PanOffset,outputRanges[HeadOffset+PanOffset][MinRange]);
	pan->setOutputCmd(HeadOffset+RollOffset,0);
	pan->advanceTime(reposTime);
	pan->setOutputCmd(HeadOffset+TiltOffset,0);
	pan->setOutputCmd(HeadOffset+PanOffset,0);
	pan->setOutputCmd(HeadOffset+RollOffset,0);
	pan->advanceTime(reposTime);
	pan->setOutputCmd(HeadOffset+TiltOffset,0);
	pan->setOutputCmd(HeadOffset+PanOffset,0);
	pan->setOutputCmd(HeadOffset+RollOffset,0);
	motman->addPrunableMotion(pan);
	erouter->addTimer(this,0,startrec+lagTime,false);
	erouter->addTimer(this,1,stoprec+lagTime,false);
}

void
WallTestBehavior::DoStop() {
	erouter->removeListener(this);
	BehaviorBase::DoStop(); // do this last
}

void
WallTestBehavior::processEvent(const EventBase& e) {
	if(e.getGeneratorID()==EventBase::sensorEGID) {
#ifdef TGT_ERS7
		float nd = state->sensors[NearIRDistOffset];
		if(false && nd<350) //force always use the far sensor - near is crappy(ier); without the 'false', would use either one
			usedNear.push_back(true);
		else {
			nd=state->sensors[FarIRDistOffset];
			usedNear.push_back(false);
		}
#else //not TGT_ERS7
		float nd = state->sensors[IRDistOffset];
#endif //not TGT_ERS7
		float na = state->outputs[HeadOffset+PanOffset];
		//cout << nd << ' ' << na << endl;
		d.push_back(nd);
		a.push_back(na);

	} else if(e.getSourceID()==0) {
		erouter->addListener(this,EventBase::sensorEGID,SensorSourceID::UpdatedSID);
	} else if(e.getSourceID()==1) {
		erouter->removeListener(this,EventBase::sensorEGID);
				
		PostureEngine pose;
		pose.clear();
		//float legheight=NEWMAT::ColumnVector(pose.getJointInterestPoint(BaseFrameOffset,"LFrPaw"))(3);

		cout << "Logging Non-Kinematic calculations to /data/raw_xy.txt" << endl;
		{
			ofstream rawxy("/ms/data/raw_xy.txt");
			if(!rawxy) {
				cout << "Could not open file" << endl;
			} else {
				cout << "Columns are:\tx\ty" << endl;
				for(unsigned int i=0; i<d.size(); i++)
					rawxy << d[i]*cos(a[i]) << '\t' << d[i]*sin(a[i]) << '\n';
			}
		}

		cout << "Logging uncalibrated kinematic calculations to /data/k_xyz.txt" << endl;
		//assumes IR is parallel to camera
		{
			ofstream kxys("/ms/data/k_xyz.txt");
			if(!kxys) {
				cout << "Could not open file" << endl;
			} else {
#ifdef TGT_ERS7
				cout << "Columns are:\tx\ty\tz\tis_using_near" << endl;
				float off=NEWMAT::ColumnVector(pose.getJointInterestPoint(CameraFrameOffset,"NearIR"))(3);
#else //not TGT_ERS7
				cout << "Columns are:\tx\ty\tz" << endl;
				float off=NEWMAT::ColumnVector(pose.getJointInterestPoint(CameraFrameOffset,"IR"))(3);
#endif //not TGT_ERS7
				for(unsigned int i=0; i<d.size(); i++) {
					pose(HeadOffset+PanOffset)=a[i];
					NEWMAT::ColumnVector hit=pose.jointToBase(CameraFrameOffset)*Kinematics::pack(0,0,d[i]+off);
#ifdef TGT_ERS7
					kxys << hit(1) << '\t' << hit(2) << '\t' << hit(3) << '\t' << usedNear[i] << '\n';
#else //not TGT_ERS7
					kxys << hit(1) << '\t' << hit(2) << '\t' << hit(3) << '\n';
#endif //not TGT_ERS7
				}
			}
		}

		cout << "Logging calibrated kinematic calculations to /data/ck_xyz.txt" << endl;
		{
			ofstream ckxys("/ms/data/ck_xyz.txt");
			if(!ckxys) {
				cout << "Could not open file" << endl;
			} else {
#ifdef TGT_ERS7
				cout << "Columns are:\tx\ty\tz\tis_using_near" << endl;
#else //not TGT_ERS7
				cout << "Columns are:\tx\ty\tz" << endl;
#endif //not TGT_ERS7
				for(unsigned int i=0; i<d.size(); i++) {
					pose(HeadOffset+PanOffset)=a[i];
#ifdef TGT_ERS7
					unsigned int frame=usedNear[i]?NearIRFrameOffset:FarIRFrameOffset;
					NEWMAT::ColumnVector hit=pose.jointToBase(frame)*Kinematics::pack(0,0,d[i]);
					ckxys << hit(1) << '\t' << hit(2) << '\t' << hit(3) << '\t' << usedNear[i] << '\n';
#else //not TGT_ERS7
					NEWMAT::ColumnVector hit=pose.jointToBase(IRFrameOffset)*Kinematics::pack(0,0,d[i]);
					ckxys << hit(1) << '\t' << hit(2) << '\t' << hit(3) << '\n';
#endif //not TGT_ERS7
				}
			}
		}

		//find data regions
		unsigned int start[3];
		unsigned int stop[3];
		start[0]=stop[0]=0;
		while(a[stop[0]++]>60*M_PI/180 && stop[0]<a.size()) ;
		start[1]=stop[0];
		while(a[start[1]++]>30*M_PI/180 && start[1]<a.size()) ;
		stop[1]=start[1];
		while(a[stop[1]++]>-30*M_PI/180 && stop[1]<a.size()) ;
		start[2]=stop[1];
		while(a[start[2]++]>-60*M_PI/180 && start[2]<a.size()) ;
		stop[2]=a.size();
			
		cout << "Regions are: ";
		for(int i=0; i<3; i++)
			cout << start[i] << "-" << stop[i] << (i==2?"":", ");
		cout << endl;

		for(int w=0; w<3; w++) {
			cout << "Wall "<<w<<": ";
			//convert radial coordinates to x,y coordinates
			int n=stop[w]-start[w];
			if(n<3) {
				cout << "not enough data - did you forget to turn off estop?" << endl;
				continue;
			}
			vector<float> x,y;
			for(unsigned int i=start[w]; i<stop[w]; i++) {
#ifdef TGT_ERS7
				if(d[i]==200 || d[i]>1500) //limits for the far sensor, near sensor is [50,500]
					continue;
#else //not ers-7
				if(d[i]==100 || d[i]>700)
					continue;
#endif //not ers-7
				x.push_back(d[i]*cos(a[i]));
				y.push_back(d[i]*sin(a[i]));
			}
			cout << "(" << x.size() << " valid samples)" << endl;
			if(x.size()<3) {
				cout << "No wall" << endl;
				continue;
			}

			float x0=0,x1=0;
			TimeET t;

			t.Set();
			solve1(x,y,x0,x1);
			cout << "   QR: 'y = "<<x0<<"x + "<<x1<<"'\tTime:"<<t.Age()<<endl;

			t.Set();
			solve2(x,y,x0,x1);
			cout << "  SVD: '"<<x0<<"x + "<<x1<<"y = 1'\tTime:"<<t.Age()<<endl;
		}
	}
}

void
WallTestBehavior::solve1(const std::vector<float>& x, const std::vector<float>& y, float& x0, float& x1) {
	NEWMAT::Matrix A(x.size(),2); //x values in first column, 1's in second column (homogenous coordinates)
	NEWMAT::ColumnVector b(x.size()); //vector of y values
	for(unsigned int i=0; i<x.size(); i++) {
		A(i+1,1)=x[i];
		A(i+1,2)=1;
		b(i+1)=y[i];
	}

	NEWMAT::UpperTriangularMatrix U;
	NEWMAT::Matrix M;

	NEWMAT::QRZ(A,U);
	NEWMAT::QRZ(A,b,M);
	NEWMAT::ColumnVector dq = U.i()*M;

	x0=dq(1);
	x1=dq(2);
}

void
WallTestBehavior::solve2(const std::vector<float>& x, const std::vector<float>& y, float& x0, float& x1) {
	NEWMAT::Matrix A(x.size(),3); //x values in first column, y's in the second, -1's in third column (homogenous coordinates)
	for(unsigned int i=0; i<x.size(); i++) {
		A(i+1,1)=x[i];
		A(i+1,2)=y[i];
		A(i+1,3)=-1;
	}
	
	NEWMAT::DiagonalMatrix Q;
	NEWMAT::Matrix U,V;
	
	NEWMAT::SVD(A,Q,U,V,false,true);
	
	x0=V(1,V.ncols())/V(3,V.ncols());
	x1=V(2,V.ncols())/V(3,V.ncols());
}
