#include "PaceTargetsMachine.h"
#include "Behaviors/Transition.h"
#include "Behaviors/Nodes/WalkToTargetNode.h"
#include "Behaviors/Nodes/WalkNode.h"
#include "ExploreMachine.h"
#include "Behaviors/Transitions/TimeOutTrans.h"
#include "Behaviors/Transitions/VisualTargetTrans.h"
#include "Behaviors/Nodes/OutputNode.h"
#include "Behaviors/Nodes/MotionSequenceNode.h"
#include "Behaviors/Nodes/GroupNode.h"
#include "SoundPlay/SoundManager.h"

void PaceTargetsMachine::setup() {
	StateNode::setup();

	WalkNode * turnAround = new WalkNode(0,0,1);
	turnAround->setName(getName()+"::TurnAround");
	addNode(turnAround);

	GroupNode * explGrp = new GroupNode(getName()+"::ExplGroup");
	addNode(explGrp);
	{
		ExploreMachine * explore = new ExploreMachine(explGrp->getName()+"::Explore");
		explGrp->addNode(explore);
		SmallMotionSequenceNode * panhead = new SmallMotionSequenceNode(explGrp->getName()+"::PanHead","/ms/data/motion/pan_head.mot",true);
		explGrp->addNode(panhead);
	}

	WalkToTargetNode * chase = new WalkToTargetNode(ProjectInterface::visPinkBallSID);
	chase->setName(getName()+"::Chase");
	addNode(chase);

	//starts out exploring
	start=explGrp;

	Transition * tmptrans=NULL;

	//if it sees pink, chase it
	explGrp->addTransition(tmptrans=new VisualTargetTrans(chase,ProjectInterface::visPinkBallSID));
	tmptrans->setSound("cutey.wav");

	//if you lose it, explore some more
	chase->addTransition(tmptrans=chase->newDefaultLostTrans(explGrp));
	tmptrans->setSound("whimper.wav");
	
	//if you get there, turn around
	chase->addTransition(tmptrans=chase->newDefaultCloseTrans(turnAround));
	tmptrans->setSound("fart.wav");
	
	//once you've turned around, explore
	turnAround->addTransition(tmptrans=new TimeOutTrans(explGrp,3500));
	tmptrans->setSound("barkmed.wav");
	
	//preload the sounds so we don't pause on tranisitions
	sndman->LoadFile("cutey.wav");
	sndman->LoadFile("barkmed.wav");
	sndman->LoadFile("whimper.wav");
	sndman->LoadFile("fart.wav");
}

void PaceTargetsMachine::DoStart() {
	StateNode::DoStart();
	start->DoStart();
}

void PaceTargetsMachine::teardown() {
	//release the sounds
	sndman->ReleaseFile("cutey.wav");
	sndman->ReleaseFile("barkmed.wav");
	sndman->ReleaseFile("whimper.wav");
	sndman->ReleaseFile("fart.wav");
	StateNode::teardown();
}

/*! @file
 * @brief Implements PaceTargetsMachine, a StateMachine for walking back and forth between two visual targets
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_3 $
 * $Revision: 1.16 $
 * $State: Exp $
 * $Date: 2005/01/21 22:50:33 $
 */

