#include <iostream>
#include <stdlib.h>
#include "Motion/Kinematics.h"
#include "Shared/Config.h"
#include "Motion/PostureEngine.h"

namespace ROBOOP {
void serrprintf(const char* msg, int x, int y, int z) {
	printf(msg,x,y,z);
}
};

using namespace std;
using namespace NEWMAT;

unsigned int simulator_time=0;

int main(int /*argc*/, char** /*argv*/) {
	//Read config file
	config=new Config("../../../project/ms/config/tekkotsu.cfg");
	config->setValue(Config::sec_motion,"kinematics","../../../project/ms/config/ers7.kin");
	kine = new Kinematics();
	
	PostureEngine pose;
	for(unsigned int i=0; i<NumOutputs; i++)
		pose(i).weight=0;
	for(unsigned int i=PIDJointOffset; i<PIDJointOffset+NumPIDJoints; i++)
		pose(i).weight=1;
	
	ColumnVector Pobj(4);
	//Pobj(1)=100;
	//Pobj(2)=90;
	//Pobj(3)=-110;
	Pobj(1)=100;
	Pobj(2)=90;
	Pobj(3)=-110;
	Pobj(4)=1;
	
	ColumnVector Plink(4);
	Plink(1)=10;
	Plink(2)=10;
	Plink(3)=10;
	Plink(4)=1;
	
	/*for(unsigned int i=LFrLegOffset; i<LFrLegOffset+JointsPerLeg; i++)
		cout << outputNames[i] << ' ' << pose(i).value << endl;
	cout << pose.getTransformFrames(LFrLegOffset+KneeOffset,LFrLegOffset+KneeOffset) << endl<<endl;
	cout << pose.getTransformFrames(LFrLegOffset+KneeOffset,LFrLegOffset+ElevatorOffset) << endl;
	cout << pose.getTransformFrames(LFrLegOffset+ElevatorOffset,LFrLegOffset+KneeOffset) << endl<<endl;
	cout << pose.getTransformFrames(LFrLegOffset+KneeOffset,LFrLegOffset+RotatorOffset) << endl;
	cout << pose.getTransformFrames(LFrLegOffset+RotatorOffset,LFrLegOffset+KneeOffset) << endl<<endl;
	cout << pose.getTransformFrames(LFrLegOffset+KneeOffset,BaseFrameOffset) << endl;
	cout << pose.getTransformFrames(BaseFrameOffset,LFrLegOffset+KneeOffset) << endl;
	*/

//	pose(LFrLegOffset+RotatorOffset)=.5;
//	pose(LFrLegOffset+ElevatorOffset)=.5;
//	pose(LFrLegOffset+KneeOffset)=.5;
	bool converged;
	converged=pose.solveLinkPosition(Pobj,PawFrameOffset+LFrLegOrder,Plink);
	cout << "LFr Converged=="<<converged<<endl;
	Pobj(2)=-Pobj(2);
	Plink(3)=-Plink(3);
	converged=pose.solveLinkPosition(Pobj,PawFrameOffset+RFrLegOrder,Plink);
	cout << "RFr Converged=="<<converged<<endl;
	Pobj(2)=-Pobj(2);
	Plink(3)=-Plink(3);
	Pobj(1)=-Pobj(1);
	converged=pose.solveLinkPosition(Pobj,PawFrameOffset+LBkLegOrder,Plink);
	cout << "LBk Converged=="<<converged<<endl;
	Pobj(2)=-Pobj(2);
	Plink(3)=-Plink(3);
	converged=pose.solveLinkPosition(Pobj,PawFrameOffset+RBkLegOrder,Plink);
	cout << "RBk Converged=="<<converged<<endl;
	Pobj(2)=-Pobj(2);
	Plink(3)=-Plink(3);
	Pobj(1)=-Pobj(1);

	Pobj(1)=300;
	Pobj(2)=-50;
	Pobj(3)=190;
	Plink=0; Plink(3)=1;
	converged=pose.solveLinkVector(Pobj,CameraFrameOffset,Plink);
	cout << "Camera Converged=="<<converged<<endl;

	for(unsigned int i=PIDJointOffset; i<PIDJointOffset+NumPIDJoints; i++)
		cout << outputNames[i] << ' ' << pose(i).value << endl;
		
/*	cout << pose.getTransformFrames(BaseFrameOffset,BaseFrameOffset) << endl;
	cout << pose.getTransformFrames(LFrLegOffset+RotatorOffset,BaseFrameOffset) << endl;
	cout << pose.getTransformFrames(LFrLegOffset+ElevatorOffset,BaseFrameOffset) << endl;
	cout << pose.getTransformFrames(LFrLegOffset+KneeOffset,BaseFrameOffset) << endl;
	cout << pose.getTransformFrames(PawFrameOffset+LFrLegOrder,BaseFrameOffset) << endl;
	
	cout << pose.getTransformLinks(BaseFrameOffset,BaseFrameOffset) << endl;
	cout << pose.getTransformLinks(LFrLegOffset+RotatorOffset,BaseFrameOffset) << endl;
	cout << pose.getTransformLinks(LFrLegOffset+ElevatorOffset,BaseFrameOffset) << endl;
	cout << pose.getTransformLinks(LFrLegOffset+KneeOffset,BaseFrameOffset) << endl;
	cout << pose.getTransformLinks(PawFrameOffset+LFrLegOrder,BaseFrameOffset) << endl; */
	
	return 0;
}

