package org.tekkotsu.mon;

import java.net.DatagramSocket;
import java.net.*;


public abstract class UDPListener extends Listener {
  public abstract void connected(DatagramSocket socket);

  String message = new String("connection request");
  byte[] buf = message.getBytes();

  public void runServer() {
    try {
      _socket=new DatagramSocket(_port);

      try {
        _socket.connect(InetAddress.getByName(_host), _port);
        _socket.setSoTimeout(2000); // block for 2 seconds at most
      } catch (Exception ex) { }

      // send a dummy message so that the AIBO can see what
      // address to connect it's UDP socket to
      DatagramPacket message = new DatagramPacket(buf, buf.length,
                                                  InetAddress.getByName(_host),
                                                  _port);
      _socket.send(message);

      connected(_socket);
    } catch (Exception ex) {
      System.out.println("port "+_port+": "+ex);
    }
  }

  public void runConnect() {
    try {
      _socket=new DatagramSocket(_port);

      try {
        _socket.connect(InetAddress.getByName(_host), _port);
        _socket.setSoTimeout(2000); // block for 2 seconds at most
      } catch (Exception ex) { }

      // send a dummy message so that the AIBO can see what
      // address to connect it's UDP socket to
      DatagramPacket message = new DatagramPacket(buf, buf.length,
                                                  InetAddress.getByName(_host),
                                                  _port);
      _socket.send(message);

      connected(_socket);
    } catch (Exception ex) { }
  }

  public void close() {

	try{_socket.close();}
	catch(Exception e){}

  }

  public UDPListener() { super(); }
  public UDPListener(int port) { super(port); }
  public UDPListener(String host, int port) { super(host, port); }

  DatagramSocket _socket;
}
