#include "StartupBehavior.h"

#include "Behaviors/Controls/ControlBase.h"
#include "Behaviors/Controls/BehaviorSwitchControl.h"

#include "Behaviors/Demos/AlanBehavior.h"
#include "Behaviors/Demos/ChaseBallBehavior.h"
#include "Behaviors/Demos/FollowHeadBehavior.h"
#include "Behaviors/Demos/WalkToTargetMachine.h"
#include "Behaviors/Demos/HelloWorldBehavior.h"
#include "Behaviors/Demos/BanditMachine.h"
#include "Behaviors/Demos/SoundTestBehavior.h"
#include "Behaviors/Demos/ExploreMachine.h"
#include "Behaviors/Demos/PaceTargetsMachine.h"
#include "Behaviors/Demos/StareAtPawBehavior.h"
#include "Behaviors/Demos/StareAtPawBehavior2.h"
#include "Behaviors/Demos/KinematicSampleBehavior.h"
#include "Behaviors/Demos/KinematicSampleBehavior2.h"
#include "Behaviors/Demos/GroundPlaneBehavior.h"
#include "Behaviors/Demos/LookForSoundBehavior.h"
#include "Behaviors/Demos/SimpleChaseBallBehavior.h"
#include "Behaviors/Demos/StareAtBallBehavior.h"

#include "Shared/ProjectInterface.h"

ControlBase*
StartupBehavior::SetupModeSwitch() {
	addItem(new ControlBase("Mode Switch","Contains the \"major\" applications - mutually exclusive selection"));
	startSubMenu();
	{
		//this group allows the behaviors to turn each other off when you start a new one so
		//only one is running at a time - like radio buttons
		BehaviorSwitchControlBase::BehaviorGroup * bg = new BehaviorSwitchControlBase::BehaviorGroup();

		//put behaviors here:
		addItem(new BehaviorSwitchControl<HelloWorldBehavior>("HelloWorldBehavior",false));
		if(state->robotDesign&(WorldState::ERS210Mask|WorldState::ERS7Mask)) //this one only really works on the 210 or 7
			addItem(new BehaviorSwitchControl<AlanBehavior>("AlanBehavior",bg,false));
		addItem(new BehaviorSwitchControl<FollowHeadBehavior>("FollowHeadBehavior",bg,false));
		addItem(new BehaviorSwitchControl<StareAtBallBehavior>("StareAtBallBehavior",false));
		addItem(new BehaviorSwitchControl<SimpleChaseBallBehavior>("SimpleChaseBallBehavior",false));
		addItem(new BehaviorSwitchControl<ChaseBallBehavior>("ChaseBallBehavior",bg,false));
		addItem(new BehaviorSwitchControl<SoundTestBehavior>("SoundTestBehavior",bg,false));
		addItem(new BehaviorSwitchControl<LookForSoundBehavior>("LookForSoundBehavior",bg,false));
		addItem(new ControlBase("State Machine Demos","More fully developed demo applications"));
		startSubMenu();
		{
			addItem(new BehaviorSwitchControlBase(new WalkToTargetMachine(ProjectInterface::visPinkBallSID),bg));
			addItem(new BehaviorSwitchControl<BanditMachine>("BanditMachine",bg,false));
			addItem(new BehaviorSwitchControl<ExploreMachine>("ExploreMachine",bg,false));
			addItem(new BehaviorSwitchControl<PaceTargetsMachine>("PaceTargetsMachine",bg,false));
		}
		endSubMenu();
		addItem(new ControlBase("Kinematics Demos","Showcases some of the newly developed kinematics code"));
		startSubMenu();
		{
			addItem(new BehaviorSwitchControl<KinematicSampleBehavior>("KinematicSampleBehavior",bg,false));
			addItem(new BehaviorSwitchControl<KinematicSampleBehavior2>("KinematicSampleBehavior2",bg,false));
			addItem(new BehaviorSwitchControl<StareAtPawBehavior>("StareAtPawBehavior",bg,false));
			addItem(new BehaviorSwitchControl<StareAtPawBehavior2>("StareAtPawBehavior2",bg,false));
			addItem(new BehaviorSwitchControl<GroundPlaneBehavior>("GroundPlaneBehavior",bg,false));
		}
		endSubMenu();
	}
	return endSubMenu();
}

