#include "StartupBehavior.h"

#include "Behaviors/Controls/ControlBase.h"
#include "Behaviors/Controls/BehaviorSwitchControl.h"

#include "Behaviors/Demos/SimpleChaseBallBehavior.h"
#include "Behaviors/Demos/StareAtBallBehavior.h"
#include "Behaviors/Demos/AutoGetupBehavior.h"
#include "Behaviors/Demos/BatteryMonitorBehavior.h"
#include "Behaviors/Demos/HeadLevelBehavior.h"
#include "Behaviors/Demos/ToggleHeadLightBehavior.h"
#include "Behaviors/Demos/CrashTestBehavior.h"
#include "Behaviors/Demos/FreezeTestBehavior.h"
#include "Behaviors/Demos/RelaxBehavior.h"
#include "Behaviors/Demos/WorldStateVelDaemon.h"
#include "Behaviors/Demos/CameraBehavior.h"
#include "Behaviors/Demos/MotionStressTestBehavior.h"
#include "Behaviors/Demos/ASCIIVisionBehavior.h"

#include "Shared/WorldState.h"
#include "Shared/ERS210Info.h"

ControlBase*
StartupBehavior::SetupBackgroundBehaviors() {
	addItem(new ControlBase("Background Behaviors","Background daemons and monitors"));
	startSubMenu();
	{ 
		addItem(new BehaviorSwitchControl<SimpleChaseBallBehavior>("SimpleChaseBallBehavior",false));
		addItem(new BehaviorSwitchControl<StareAtBallBehavior>("StareAtBallBehavior",false));
		addItem(new BehaviorSwitchControl<HeadLevelBehavior>("HeadLevelBehavior",false));
		if(state->robotDesign & WorldState::ERS220Mask)
			addItem(new BehaviorSwitchControl<ToggleHeadLightBehavior>("ToggleHeadLightBehavior",false));
		addItem(new BehaviorSwitchControl<RelaxBehavior>("RelaxBehavior",false));
		addItem(new BehaviorSwitchControl<CameraBehavior>("CameraBehavior",false));
		addItem(new BehaviorSwitchControl<ASCIIVisionBehavior>("ASCIIVisionBehavior",false));
		addItem(new ControlBase("Debugging Tests","Stress tests"));
		startSubMenu();
		{
			addItem(new BehaviorSwitchControl<MotionStressTestBehavior>("MotionStressTestBehavior",false));
			addItem(new BehaviorSwitchControl<CrashTestBehavior>("CrashTestBehavior",false));
			addItem(new BehaviorSwitchControl<FreezeTestBehavior>("FreezeTestBehavior",false));
		}
		endSubMenu();
		addItem(new ControlBase("System Daemons","Provide some common sensor or event processing"));
		startSubMenu();
		{
			addItem((new BehaviorSwitchControl<AutoGetupBehavior>("AutoGetupBehavior",false)));
			addItem((new BehaviorSwitchControl<WorldStateVelDaemon>("WorldStateVelDaemon",false))->start());
			addItem((new BehaviorSwitchControl<BatteryMonitorBehavior>("BatteryMonitorBehavior",false))->start());
		}
		endSubMenu();
	}
	return endSubMenu();
}
