/*
Copyright (C) 2003-2004  Etienne Lachance

This library is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as
published by the Free Software Foundation; either version 2.1 of the
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


Report problems and direct all questions to:

email: etienne.lachance@polytml.ca or richard.gourdeau@polymtl.ca
-------------------------------------------------------------------------------
Revision_history:

2004/07/01: Etienne Lachance
   -Added doxygen documentation.

2004/07/01: Ethan Tira-Thompson
    -Added support for newmat's use_namespace #define, using ROBOOP namespace
    -Added dependance on utils.h because we need to get the use_namespace setting

2004/07/13: Ethan Tira-Thompson
    -Added a select_real and add_real function for type indepence of Real
    -Added functions to test for sections and parameters existance

2004/07/23: Ethan Tira-Thompson
    -Fixed potentially uninitialized variables and some other warnings

2004/09/01: Ethan Tira-Thompson
    -Added optional parameter to constructor so you can automatically read_conf
    -select_* functions are now const
-------------------------------------------------------------------------------
*/

#ifndef CONFIG_H
#define CONFIG_H

/*!
  @file config.h
  @brief Header file for Config class definitions.
*/

//! @brief RCS/CVS version.
static const char header_config_rcsid[] = "$Id: config.h,v 1.9 2004/09/01 19:51:04 ejt Exp $";


#ifdef _MSC_VER                  // Microsoft
#pragma warning (disable:4786)  // Disable decorated name truncation warnings 
#pragma warning (disable:4503)  // Disable decorated name truncation warnings 
#endif
#include <iostream>
#include <string>
#include <iomanip>
#include <fstream>
#ifdef __WATCOMC__
#include <strstrea.h>
#else
#include <sstream>
#endif
#include <vector>

#include "utils.h"
#ifdef use_namespace
namespace ROBOOP {
  using namespace NEWMAT;
#endif

//! @brief Return when can not open file.
#define CAN_NOT_OPEN_FILE                     -1

//! @brief Return when can not create a file.
#define CAN_NOT_CREATE_FILE                   -2

//! @brief Return when a section or parameter does not exist.
#define SECTION_OR_PARAMETER_DOES_NOT_EXIST   -3

#ifndef __WATCOMC__
using namespace std;
#endif


//! @brief Basic data element used in Config class.
typedef struct Data{
   Data() : section(), parameter(), value() {}
   string section;
   string parameter;
   string value;
} Data;

//! @brief Configuration data type.
typedef vector< Data > Conf_data;

//! @brief Handle configuration files.
class Config {
public:
   Config() : conf(), filename() {}
   Config(const string & filename_,bool doRead=false);
   Config(const Config & x);
   Config & operator=(const Config & x);
   short read_conf();
   void print();

	 bool section_exists(const string& section) const;
	 bool parameter_exists(const string& section, const string& parameter) const;

   short select_string(const string section, const string parameter,
                       string & value) const;
   short select_bool(const string section, const string parameter,
                     bool & value) const;
   short select_short(const string section, const string parameter,
                      short & value) const;
   short select_int(const string section, const string parameter,
                    int & value) const;
   short select_float(const string section, const string parameter,
		      float & value) const;
   short select_double(const string section, const string parameter,
                       double & value) const;
   short select_real(const string section, const string parameter,
                       Real & value) const;

   short write_conf(const string name, const string file_title,
                    const int space_between_column);
   void add_string(const string section, const string parameter,
                   const string value);
   void add_bool(const string section, const string parameter,
                 const bool value);
   void add_int(const string section, const string parameter,
                const int value);
   void add_float(const string section, const string parameter,
                   const float value);
   void add_double(const string section, const string parameter,
                   const double value);
   void add_real(const string section, const string parameter,
                   const Real value);

private:
   Conf_data conf;   //!< Data store from/to configuration file.
   string filename;  //!< Configuration file name.
};

#ifdef use_namespace
}
#endif

#endif 


















