//-*-c++-*-
#ifndef INCLUDED_RemoteControllerMC_h
#define INCLUDED_RemoteControllerMC_h

#include "MotionCommand.h"
#include "OutputCmd.h"
#include "Shared/RobotInfo.h"

//! This class is used for setting all PIDJoints to a certain set of values (not the gains, just the joint positions)
/*! This is PostureMC's little brother.  Not quite so full of features, but straightforward and easy to understand. (hopefully) */
class RemoteControllerMC : public MotionCommand {
 public:
	//! constructor, defaults to active, all joints at 0
	RemoteControllerMC():MotionCommand(), dirty(true), active(true) {
    for (unsigned int i=0; i<NumPIDJoints; i++) cmds[i]=0.0f;
  }
	//! destructor
	virtual ~RemoteControllerMC() {}

	//!@name Inherited:
  //! Updates all PIDJoint values
	virtual int updateOutputs() {
    int tmp=isDirty();
    if (isDirty())
      for (unsigned int i=0; i<NumPIDJoints; i++)
        motman->setOutput(this, PIDJointOffset+i, cmds[i]);
    dirty=false;
    return tmp;
  }
	virtual int              isDirty()                      { return (dirty && active)?1:0; } //!< true if a change has been made since the last updateJointCmds() and we're active
	virtual int              isAlive()                      { return true; } //!< always true
	//@}
  
  void setDirty() { dirty=true; } //!< sets dirty flag to true
  float cmds[NumPIDJoints]; //!< current vector of positions

 protected:
	bool dirty;                         //!< true if a change has been made since last call to updateJointCmds()
	bool active;                        //!< set by accessor functions, defaults to true
};

/*! @file
 * @brief Describes RemoteControllerMC, a class used for setting all PIDJoints to a certain set of values (not the gains, just the joint positions)
 * @author alokl (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_2 $
 * $Revision: 1.4 $
 * $State: Exp $
 * $Date: 2004/01/07 22:52:26 $
 */

#endif

