#include "HeadPointerMC.h"
#include "Shared/debuget.h"
#include "Shared/WorldState.h"
#include "MotionManager.h"
#include <math.h>
#include "Shared/Config.h"

HeadPointerMC::HeadPointerMC()
	: MotionCommand(), dirty(true), targetReached(false),
	  headkin(::config->motion.makePath(::config->motion.kinematics),"Camera")
{
	setWeight(1);
	defaultMaxSpeed();
	for(unsigned int i=0; i<NumHeadJoints; i++)
		headTargets[i]=headCmds[i].value=state->outputs[HeadOffset+i];
}

void HeadPointerMC::defaultMaxSpeed() {
	maxSpeed[TiltOffset]=config->motion.max_head_tilt_speed*FrameTime/1000;
	maxSpeed[PanOffset]=config->motion.max_head_pan_speed*FrameTime/1000;
	maxSpeed[RollOffset]=config->motion.max_head_roll_speed*FrameTime/1000;
}

void HeadPointerMC::setWeight(float w) {
	for(unsigned int x=0; x<NumHeadJoints; x++)
		headCmds[x].weight=w;
	markDirty();
}

void HeadPointerMC::setJoints(float j1, float j2, float j3) {
	headTargets[TiltOffset]=clipAngularRange(HeadOffset+TiltOffset,j1);
	headTargets[PanOffset]=clipAngularRange(HeadOffset+PanOffset,j2);
	headTargets[RollOffset]=clipAngularRange(HeadOffset+RollOffset,j3);
	markDirty();
}

bool HeadPointerMC::lookAtPoint(float x, float y, float z) {
	NEWMAT::ColumnVector Pobj(4),Plink(4);
	Pobj(1)=x; Pobj(2)=y; Pobj(3)=z; Pobj(4)=1;
	Plink=0; Plink(3)=1;
	bool conv=false;
	NEWMAT::ColumnVector q=headkin.inv_kin_pos(Pobj,0,headkin.get_dof(),Plink,conv);
	for(unsigned int i=0; i<NumHeadJoints; i++)
		setJointValue(i,headkin.get_q(2+i));
	return conv;
}
	
bool HeadPointerMC::lookAtPoint(float x, float y, float z, float d) {
	NEWMAT::ColumnVector Pobj(4),Plink(4);
	Pobj(1)=x; Pobj(2)=y; Pobj(3)=z; Pobj(4)=1;
	Plink=0; Plink(3)=d; Plink(4)=1;
	bool conv=false;
	NEWMAT::ColumnVector q=headkin.inv_kin_pos(Pobj,0,headkin.get_dof(),Plink,conv);
	for(unsigned int i=0; i<NumHeadJoints; i++)
		setJointValue(i,headkin.get_q(2+i));
	return conv;
}
	
bool HeadPointerMC::lookInDirection(float x, float y, float z) {
	NEWMAT::ColumnVector Pobj(4),Plink(4);
	Pobj(1)=x; Pobj(2)=y; Pobj(3)=z; Pobj(4)=0;
	Plink=0; Plink(3)=1;
	bool conv=false;
	NEWMAT::ColumnVector q=headkin.inv_kin_pos(Pobj,0,headkin.get_dof(),Plink,conv);
	for(unsigned int i=0; i<NumHeadJoints; i++)
		setJointValue(i,headkin.get_q(2+i));
	return conv;
}

int HeadPointerMC::updateOutputs() {
	int tmp=isDirty();
	if(tmp) {
		dirty=false;
		for(unsigned int i=0; i<NumHeadJoints; i++) {
      if(maxSpeed[i]<=0) {
				headCmds[i].value=headTargets[i];
				motman->setOutput(this,i+HeadOffset,headCmds[i]);
			} else { // we may be trying to exceeded maxSpeed
				unsigned int f=0;
				while(headTargets[i]>headCmds[i].value+maxSpeed[i] && f<NumFrames) {
					headCmds[i].value+=maxSpeed[i];
					motman->setOutput(this,i+HeadOffset,headCmds[i],f);
					f++;
				}
				while(headTargets[i]<headCmds[i].value-maxSpeed[i] && f<NumFrames) {
					headCmds[i].value-=maxSpeed[i];
					motman->setOutput(this,i+HeadOffset,headCmds[i],f);
					f++;
				}
				if(f<NumFrames) { //we reached target value, fill in rest of frames
					headCmds[i].value=headTargets[i];
					for(;f<NumFrames;f++)
						motman->setOutput(this,i+HeadOffset,headCmds[i],f);
				} else // we didn't reach target value, still dirty
					dirty=true;
			}
		}
		if(!dirty && !targetReached) {
			postEvent(EventBase(EventBase::motmanEGID,getID(),EventBase::statusETID));
			targetReached=true;
		}
	}
	return tmp;
}

void HeadPointerMC::markDirty() {
	dirty=true;
	targetReached=false;
}

/*! @file
 * @brief Implements HeadPointerMC, a class for various ways to control where the head is looking
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_2 $
 * $Revision: 1.14 $
 * $State: Exp $
 * $Date: 2004/10/14 21:59:23 $
 */


