#include "TextMsgEvent.h"
#include <sstream>

std::string
TextMsgEvent::getDescription(bool showTypeSpecific/*=true*/, unsigned int verbosity/*=0*/) const {
	if(!showTypeSpecific)
		return EventBase::getDescription(showTypeSpecific,verbosity);
	std::ostringstream logdata;
	logdata << EventBase::getDescription(showTypeSpecific,verbosity) << '\t' << _text;
	return logdata.str();
}

unsigned int
TextMsgEvent::getBinSize() const {
	unsigned int used=EventBase::getBinSize();
	used+=creatorSize("EventBase::TextMsgEvent");
	used+=_text.size()+stringpad;
	//used+=sizeof(_token);
	return used;
}

unsigned int
TextMsgEvent::LoadBuffer(const char buf[], unsigned int len) {
	unsigned int origlen=len;
	unsigned int used;
	if(0==(used=EventBase::LoadBuffer(buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=checkCreator("EventBase::TextMsgEvent",buf,len,true))) return 0;
	len-=used; buf+=used;
	if(0==(used=decode(_text,buf,len))) return 0;
	len-=used; buf+=used;
	//if(0==(used=decode(_token,buf,len))) return 0;
	//len-=used; buf+=used;
	return origlen-len;	
}

unsigned int
TextMsgEvent::SaveBuffer(char buf[], unsigned int len) const {
	unsigned int origlen=len;
	unsigned int used;
	if(0==(used=EventBase::SaveBuffer(buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=saveCreator("EventBase::TextMsgEvent",buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=encode(_text,buf,len))) return 0;
	len-=used; buf+=used;
	//if(0==(used=encode(_token,buf,len))) return 0;
	//len-=used; buf+=used;
	return origlen-len;
}

/*! @file
 * @brief Implements TextMsgEvent, which extends EventBase to also include actual message text
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_2 $
 * $Revision: 1.1 $
 * $State: Exp $
 * $Date: 2004/09/01 21:30:57 $
 */
